/*
 * Decompiled with CFR 0.152.
 */
package play.modules.spring;

import java.util.Map;
import play.Play;
import play.exceptions.UnexpectedException;
import play.modules.spring.SpringException;
import play.modules.spring.SpringPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spring {
    public static Object getBean(String name) {
        if (SpringPlugin.applicationContext == null) {
            throw new SpringException();
        }
        return SpringPlugin.applicationContext.getBean(name);
    }

    public static <T> T getBeanOfType(Class<T> type) {
        Map<String, T> beans = Spring.getBeansOfType(type);
        if (beans.isEmpty()) {
            return null;
        }
        return beans.values().iterator().next();
    }

    public static Object getBeanOfType(String type) {
        try {
            return Spring.getBeanOfType(Play.classloader.loadClass(type));
        }
        catch (ClassNotFoundException ex) {
            throw new UnexpectedException((Throwable)ex);
        }
    }

    public static <T> Map<String, T> getBeansOfType(Class type) {
        if (SpringPlugin.applicationContext == null) {
            throw new SpringException();
        }
        return SpringPlugin.applicationContext.getBeansOfType(type);
    }
}

