/*
 * Decompiled with CFR 0.152.
 */
package play.modules.springtester;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.support.GenericApplicationContext;
import play.modules.spring.Spring;
import play.modules.spring.SpringPlugin;
import play.modules.springtester.MockitoFactory;
import play.modules.springtester.PartialMock;
import play.modules.springtester.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringMockitoMaster {
    public void before(Object object, Map<String, BeanDefinition> definitions) throws IllegalAccessException {
        this.injectAnnotatedField(Resource.class, object);
        this.injectAnnotatedField(PartialMock.class, object);
        this.injectMocks(object);
        this.registerMocksAndPartialMocksInSpringContext(object, definitions);
        this.resolveBeanDefinitions(definitions);
        this.injectAnnotatedField(Subject.class, object);
    }

    public void after(Map<String, BeanDefinition> definitions) {
        Set<String> beanNames = definitions.keySet();
        for (String name : beanNames) {
            BeanDefinition definition = definitions.get(name);
            SpringPlugin.applicationContext.removeBeanDefinition(name);
            SpringPlugin.applicationContext.registerBeanDefinition(name, definition);
        }
        definitions.clear();
    }

    public void registerBeanDefinition(String name, Object object, Map<String, BeanDefinition> definitions) {
        GenericApplicationContext context = SpringPlugin.applicationContext;
        if (context.containsBeanDefinition(name)) {
            BeanDefinition beanDefinition = context.getBeanDefinition(name);
            definitions.put(name, beanDefinition);
            context.removeBeanDefinition(name);
        }
        GenericBeanDefinition definition = this.createMockitoFactoryBeanDefinition(object);
        context.registerBeanDefinition(name, (BeanDefinition)definition);
    }

    private void resolveBeanDefinitions(Map<String, BeanDefinition> definitions) {
        Set<String> keys = definitions.keySet();
        for (String key : keys) {
            Spring.getBean((String)key);
        }
    }

    private void injectAnnotatedField(Class<? extends Annotation> annotation, Object object) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            this.injectDependency(annotation, object, field);
        }
    }

    private void injectDependency(Class<? extends Annotation> annotation, Object object, Field field) throws IllegalAccessException {
        Class<?> fieldTypeClass = field.getType();
        field.setAccessible(true);
        Object value = this.getSpringBeanOfType(annotation, fieldTypeClass);
        field.set(object, value);
    }

    private Object getSpringBeanOfType(Class<? extends Annotation> annotation, Class<?> fieldTypeClass) {
        Object bean = Spring.getBeanOfType(fieldTypeClass);
        if (annotation == PartialMock.class) {
            return Mockito.spy((Object)bean);
        }
        return bean;
    }

    private void injectMocks(Object object) {
        MockitoAnnotations.initMocks((Object)object);
    }

    private void registerMocksAndPartialMocksInSpringContext(Object object, Map<String, BeanDefinition> definitions) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(Mock.class)) {
                this.registerMockInSpringContext(object, field, definitions);
            }
            if (!field.isAnnotationPresent(PartialMock.class)) continue;
            this.registerPartialMockInSpringContext(object, field, definitions);
        }
    }

    private void registerMockInSpringContext(Object object, Field field, Map<String, BeanDefinition> definitions) throws IllegalAccessException {
        Mock mock = field.getAnnotation(Mock.class);
        String name = mock.name();
        this.registerObjectInSpringContext(name, object, field, definitions);
    }

    private void registerPartialMockInSpringContext(Object object, Field field, Map<String, BeanDefinition> definitions) throws IllegalAccessException {
        PartialMock partialMock = field.getAnnotation(PartialMock.class);
        String name = partialMock.name();
        this.registerObjectInSpringContext(name, object, field, definitions);
    }

    private void registerObjectInSpringContext(String name, Object object, Field field, Map<String, BeanDefinition> definitions) throws IllegalAccessException {
        Object fieldObject = this.getValue(object, field);
        if ("".equals(name)) {
            this.registerBeanDefinitionWithFieldName(field, fieldObject, definitions);
        } else {
            this.registerBeanDefinition(name, fieldObject, definitions);
        }
    }

    private Object getValue(Object object, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        return field.get(object);
    }

    private void registerBeanDefinitionWithFieldName(Field field, Object object, Map<String, BeanDefinition> definitions) {
        String fieldName = field.getName();
        this.registerBeanDefinition(fieldName, object, definitions);
    }

    private GenericBeanDefinition createMockitoFactoryBeanDefinition(Object object) {
        GenericBeanDefinition definition = new GenericBeanDefinition();
        definition.setBeanClass(MockitoFactory.class);
        definition.setFactoryMethodName("create");
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        Mockito.reset((Object[])new Object[]{object});
        values.addGenericArgumentValue(object);
        definition.setConstructorArgumentValues(values);
        return definition;
    }
}

