package springtester;

import org.springframework.stereotype.Component;
import play.modules.spring.Spring;

import javax.annotation.Resource;

@Component
public class Person {
    // Here we are injecting the AgeCalculator and FavouriteThings into the Person class
    @Resource private AgeCalculator ageCalculator;
    @Resource private FavouriteThings favouriteThings;
    public static final String BIRTH_DATE = "1-January-1980";

    public boolean canVote() {
        int age = ageCalculator.calculate(BIRTH_DATE);
        return age >= 18;
    }

    public String sayFavouriteSport() {
        return "My favourite sport is " + favouriteThings.sport();
    }

    public String sayFavouriteNumber() {
        return "My favourite number is " + favouriteThings.number();
    }

    public int getHeight() {
        HeightCalculator calculator = Spring.getBeanOfType(HeightCalculator.class);
        return calculator.calculate();
    }
}
