/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led;

import be.objectify.led.ObjectFactory;
import be.objectify.led.factory.object.BooleanFactory;
import be.objectify.led.factory.object.ByteFactory;
import be.objectify.led.factory.object.CharacterFactory;
import be.objectify.led.factory.object.DoubleFactory;
import be.objectify.led.factory.object.FloatFactory;
import be.objectify.led.factory.object.IntegerFactory;
import be.objectify.led.factory.object.LongFactory;
import be.objectify.led.factory.object.ShortFactory;
import be.objectify.led.factory.object.StringFactory;
import be.objectify.led.util.ContractUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactoryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectFactoryRegistry.class);
    private final Map<Class, ObjectFactory> objectFactories = new HashMap<Class, ObjectFactory>();
    private static final Map<Class, Class> PRIMITIVE_TO_WRAPPER_MAP = new HashMap<Class, Class>();

    public ObjectFactoryRegistry() {
        BooleanFactory booleanFactory = new BooleanFactory();
        this.objectFactories.put(booleanFactory.getBoundClass(), booleanFactory);
        ByteFactory byteFactory = new ByteFactory();
        this.objectFactories.put(byteFactory.getBoundClass(), byteFactory);
        CharacterFactory characterFactory = new CharacterFactory();
        this.objectFactories.put(characterFactory.getBoundClass(), characterFactory);
        DoubleFactory doubleFactory = new DoubleFactory();
        this.objectFactories.put(doubleFactory.getBoundClass(), doubleFactory);
        FloatFactory floatFactory = new FloatFactory();
        this.objectFactories.put(floatFactory.getBoundClass(), floatFactory);
        IntegerFactory integerFactory = new IntegerFactory();
        this.objectFactories.put(integerFactory.getBoundClass(), integerFactory);
        LongFactory longFactory = new LongFactory();
        this.objectFactories.put(longFactory.getBoundClass(), longFactory);
        ShortFactory shortFactory = new ShortFactory();
        this.objectFactories.put(shortFactory.getBoundClass(), shortFactory);
        StringFactory stringFactory = new StringFactory();
        this.objectFactories.put(stringFactory.getBoundClass(), stringFactory);
    }

    public void register(ObjectFactory ... objectFactories) {
        ContractUtils.nonNull(objectFactories, "objectFactories");
        this.register(Arrays.asList(objectFactories));
    }

    public void register(List<ObjectFactory> objectFactories) {
        ContractUtils.nonNull(objectFactories, "objectFactories");
        for (ObjectFactory objectFactory : objectFactories) {
            this.objectFactories.put(objectFactory.getBoundClass(), objectFactory);
        }
    }

    public ObjectFactory getFactory(Class clazz) {
        ObjectFactory factory;
        if (clazz.isPrimitive()) {
            clazz = PRIMITIVE_TO_WRAPPER_MAP.get(clazz);
        }
        if ((factory = this.objectFactories.get(clazz)) != null) {
            LOGGER.debug("Found object factory [{}] for class [{}]", (Object)factory, (Object)clazz.getCanonicalName());
        } else {
            LOGGER.debug("Could not find object factory for {}", (Object)clazz.getCanonicalName());
        }
        return factory;
    }

    static {
        PRIMITIVE_TO_WRAPPER_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPER_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER_MAP.put(Short.TYPE, Short.class);
    }
}

