/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led;

import be.objectify.led.Property;
import be.objectify.led.PropertySorter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDigger {
    private PropertyDigger() {
    }

    public static List<String> getPropertyNames(Class c) {
        return PropertyDigger.getPropertyNames(c, SortOrder.NATURAL);
    }

    public static List<String> getPropertyNames(Class c, PropertySorter propertySorter) {
        List<Property> properties = PropertyDigger.getProperties(c, propertySorter);
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Property property : properties) {
            propertyNames.add(property.value());
        }
        return propertyNames;
    }

    public static List<Property> getProperties(Class c) {
        return PropertyDigger.getProperties(c, SortOrder.NATURAL);
    }

    public static List<Property> getProperties(Class c, PropertySorter propertySorter) {
        Field[] fields;
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Field field : fields = c.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            properties.add(field.getAnnotation(Property.class));
        }
        propertySorter.sort(properties);
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder implements PropertySorter
    {
        NATURAL{

            @Override
            public void sort(List<Property> properties) {
            }
        }
        ,
        BY_NAME{

            @Override
            public void sort(List<Property> properties) {
                Collections.sort(properties, new Comparator<Property>(){

                    @Override
                    public int compare(Property propertyA, Property propertyB) {
                        return propertyA.value().compareTo(propertyB.value());
                    }
                });
            }
        };

    }
}

