/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led.factory.object;

import be.objectify.led.PropertyContext;
import be.objectify.led.factory.object.AbstractObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFactory
extends AbstractObjectFactory<Enum> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumFactory.class);
    private final Class<? extends Enum> clazz;

    public EnumFactory(Class<? extends Enum> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Enum createObject(String propertyName, String propertyValue, PropertyContext propertyContext) {
        Enum value = null;
        if (propertyValue != null) {
            propertyValue = propertyValue.trim();
            try {
                value = this.getValue(this.clazz, propertyValue);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(String.format("Unable to parse %s to enum of type [%s]", propertyValue, this.clazz), (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public Class<Enum> getBoundClass() {
        return Enum.class;
    }

    private Enum getValue(Class<? extends Enum> clazz, String value) throws IllegalArgumentException {
        Enum e;
        try {
            e = Enum.valueOf(clazz, value);
        }
        catch (IllegalArgumentException e1) {
            try {
                e = Enum.valueOf(clazz, value.toUpperCase());
            }
            catch (IllegalArgumentException e2) {
                e = Enum.valueOf(clazz, value.toLowerCase());
            }
        }
        return e;
    }
}

