/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led.factory.type;

import be.objectify.led.FactoryResolver;
import be.objectify.led.GenericTypes;
import be.objectify.led.ObjectFactory;
import be.objectify.led.PropertyContext;
import be.objectify.led.TypeFactory;
import be.objectify.led.factory.object.ListFactory;
import be.objectify.led.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTypeFactory
implements TypeFactory<List> {
    private final FactoryResolver factoryResolver;

    public ListTypeFactory(FactoryResolver factoryResolver) {
        this.factoryResolver = factoryResolver;
    }

    public ListFactory createObjectFactory(Class[] classes, Field field) {
        return new ListFactory(classes[0], field, this.factoryResolver){

            protected Collection parse(String propertyName, String propertyValue, PropertyContext propertyContext, ObjectFactory objectFactory) {
                ArrayList list = new ArrayList();
                if (!StringUtils.isEmpty(propertyValue)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(propertyValue);
                    while (stringTokenizer.hasMoreTokens()) {
                        list.add(objectFactory.createObject(propertyName, stringTokenizer.nextToken(), propertyContext));
                    }
                }
                return list;
            }

            protected List createList() {
                return new ArrayList();
            }
        };
    }

    @Override
    public Class<List> getBoundClass() {
        return List.class;
    }

    @Override
    public Class[] determineClassType(Class fieldType, GenericTypes genericTypes) {
        if (genericTypes == null || genericTypes.value().length != 1) {
            throw new RuntimeException("GenericTypes(value class) annotation required to determine Collection value type");
        }
        return genericTypes.value();
    }
}

