/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led;

import be.objectify.led.FactoryResolver;
import be.objectify.led.GenericTypes;
import be.objectify.led.ObjectFactory;
import be.objectify.led.ObjectFactoryRegistry;
import be.objectify.led.TypeFactory;
import be.objectify.led.TypeFactoryRegistry;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFactoryResolver
implements FactoryResolver {
    private final ObjectFactoryRegistry objectFactoryRegistry;
    private final TypeFactoryRegistry typeFactoryRegistry;

    public DefaultFactoryResolver() {
        this(new ObjectFactoryRegistry(), new TypeFactoryRegistry());
    }

    public DefaultFactoryResolver(ObjectFactoryRegistry objectFactoryRegistry) {
        this(objectFactoryRegistry, new TypeFactoryRegistry());
    }

    public DefaultFactoryResolver(TypeFactoryRegistry typeFactoryRegistry) {
        this(new ObjectFactoryRegistry(), typeFactoryRegistry);
    }

    public DefaultFactoryResolver(ObjectFactoryRegistry objectFactoryRegistry, TypeFactoryRegistry typeFactoryRegistry) {
        this.objectFactoryRegistry = objectFactoryRegistry;
        this.typeFactoryRegistry = typeFactoryRegistry;
    }

    @Override
    public ObjectFactory resolveFactory(Class<?> type, Field field) {
        ObjectFactory objectFactory = this.objectFactoryRegistry.getFactory(type);
        if (objectFactory == null) {
            GenericTypes genericTypes = field.getAnnotation(GenericTypes.class);
            TypeFactory factory = this.typeFactoryRegistry.getFactory(type);
            if (factory != null) {
                objectFactory = factory.createObjectFactory(factory.determineClassType(type, genericTypes), field);
            }
        }
        return objectFactory;
    }
}

