/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led;

import be.objectify.led.PropertyContext;
import be.objectify.led.util.ContractUtils;
import be.objectify.led.util.StringUtils;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyContext
implements PropertyContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPropertyContext.class);
    private final Properties properties = new Properties();

    public DefaultPropertyContext(Properties ... properties) {
        ContractUtils.nonNull(properties, "properties");
        for (Properties propertiesInstance : properties) {
            this.properties.putAll((Map<?, ?>)propertiesInstance);
        }
    }

    public String getValue(String propertyName) {
        String property;
        String value = null;
        if (this.properties.containsKey(propertyName)) {
            value = this.properties.getProperty(propertyName);
        }
        if (!StringUtils.isEmpty(property = System.getProperty(propertyName))) {
            value = property;
        }
        if (value != null) {
            LOGGER.debug("Found value [{}] for property [{}]", (Object)value, (Object)propertyName);
        }
        return value;
    }
}

