/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led;

import be.objectify.led.DefaultFactoryResolver;
import be.objectify.led.DefaultPropertyContext;
import be.objectify.led.FactoryResolver;
import be.objectify.led.ObjectFactory;
import be.objectify.led.Property;
import be.objectify.led.PropertyContext;
import be.objectify.led.PropertySetterConfiguration;
import be.objectify.led.util.ContractUtils;
import be.objectify.led.util.StringUtils;
import be.objectify.led.validation.ValidationFunction;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertySetter.class);
    private final FactoryResolver factoryResolver;
    private final PropertyContext propertyContext;
    private final PropertySetterConfiguration configuration;

    public PropertySetter() {
        this(new DefaultFactoryResolver(), new DefaultPropertyContext(new Properties[0]));
    }

    public PropertySetter(PropertyContext propertyContext) {
        this(new DefaultFactoryResolver(), propertyContext);
    }

    public PropertySetter(FactoryResolver factoryResolver, PropertyContext propertyContext) {
        ContractUtils.notNull(factoryResolver, "factoryResolver");
        ContractUtils.notNull(propertyContext, "propertyContext");
        this.factoryResolver = factoryResolver;
        this.propertyContext = propertyContext;
        this.configuration = new PropertySetterConfiguration();
    }

    public void process(Class target, ValidationFunction ... validationFunctions) {
        Field[] fields;
        for (Field field : fields = target.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class) || !Modifier.isStatic(field.getModifiers())) continue;
            this.setProperty(target, field, validationFunctions);
        }
    }

    public void process(Object target, ValidationFunction ... validationFunctions) {
        Field[] fields;
        for (Field field : fields = target.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            this.setProperty(target, field, validationFunctions);
        }
    }

    private void setProperty(Object target, Field field, ValidationFunction ... validationFunctions) {
        String propertyValue = this.getProperty(field);
        boolean finalField = Modifier.isFinal(field.getModifiers());
        if (!(StringUtils.isEmpty(propertyValue) || finalField && !this.configuration.isAllowFinalSetting())) {
            Class<?> type = field.getType();
            ObjectFactory objectFactory = this.factoryResolver.resolveFactory(type, field);
            if (objectFactory != null) {
                String fieldName = field.getAnnotation(Property.class).value();
                objectFactory.validate(fieldName, propertyValue, validationFunctions);
                this.setValue(target, field, objectFactory.createObject(fieldName, propertyValue, this.propertyContext));
            } else {
                LOGGER.info("No factory available for type [{}]", type);
            }
        }
    }

    private void setValue(Object target, Field field, Object value) {
        if (value != null) {
            try {
                boolean accessibleState = field.isAccessible();
                if (!accessibleState) {
                    field.setAccessible(true);
                }
                field.set(target, value);
                field.setAccessible(accessibleState);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Unable to set property", (Throwable)e);
            }
        }
    }

    private String getProperty(AccessibleObject accessibleObject) {
        Property annotation = accessibleObject.getAnnotation(Property.class);
        String propertyName = annotation.value();
        String propertyValue = this.propertyContext.getValue(propertyName);
        if (!StringUtils.isEmpty(propertyValue)) {
            LOGGER.debug("Found value [{}] for system property [{}] on [{}]", new Object[]{propertyValue, propertyName, accessibleObject.toString()});
        }
        return propertyValue;
    }

    public PropertySetterConfiguration getConfiguration() {
        return this.configuration;
    }
}

