/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led;

import be.objectify.led.TypeFactory;
import be.objectify.led.util.ContractUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFactoryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeFactoryRegistry.class);
    private final Map<Class, TypeFactory> typeFactories = new LinkedHashMap<Class, TypeFactory>();

    public void register(TypeFactory ... typeFactories) {
        ContractUtils.nonNull(typeFactories, "typeFactories");
        this.register(Arrays.asList(typeFactories));
    }

    public void register(List<TypeFactory> typeFactories) {
        ContractUtils.nonNull(typeFactories, "typeFactories");
        for (TypeFactory typeFactory : typeFactories) {
            this.typeFactories.put(typeFactory.getBoundClass(), typeFactory);
        }
    }

    public TypeFactory getFactory(Class clazz) {
        TypeFactory factory = this.typeFactories.get(clazz);
        if (factory == null) {
            Set<Class> keySet = this.typeFactories.keySet();
            Iterator<Class> it = keySet.iterator();
            while (factory == null && it.hasNext()) {
                Class c = it.next();
                if (!c.isAssignableFrom(clazz)) continue;
                factory = this.typeFactories.get(c);
                LOGGER.debug("Found type factory [{}] for class [{}] using supertype [{}]", new Object[]{factory, clazz.getCanonicalName(), c.getCanonicalName()});
            }
            if (factory == null) {
                LOGGER.debug("Could not find type factory for class [{}]", (Object)clazz.getCanonicalName());
            }
        } else {
            LOGGER.debug("Found type factory [{}] for class [{}]", (Object)factory, (Object)clazz.getCanonicalName());
        }
        return factory;
    }
}

