/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led.factory.object;

import be.objectify.led.FactoryResolver;
import be.objectify.led.ObjectFactory;
import be.objectify.led.PropertyContext;
import be.objectify.led.factory.object.AbstractObjectFactory;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListFactory<T>
extends AbstractObjectFactory<List> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListFactory.class);
    private final Class clazz;
    private final Field field;
    private final FactoryResolver factoryResolver;

    public ListFactory(Class clazz, Field field, FactoryResolver factoryResolver) {
        this.clazz = clazz;
        this.field = field;
        this.factoryResolver = factoryResolver;
    }

    @Override
    public List<T> createObject(String propertyName, String propertyValue, PropertyContext propertyContext) {
        List<T> list = this.createList();
        ObjectFactory objectFactory = this.factoryResolver.resolveFactory(this.clazz, this.field);
        if (objectFactory == null) {
            LOGGER.info("No factory available for type [{}]", (Object)this.clazz.getCanonicalName());
        } else {
            Collection<T> values = this.parse(propertyName, propertyValue, propertyContext, objectFactory);
            if (values != null) {
                list.addAll(values);
            } else {
                LOGGER.info("Property value [{}] did not parse into collection of type [{}]", (Object)propertyValue, (Object)this.clazz.getCanonicalName());
            }
        }
        return list;
    }

    @Override
    public Class<List> getBoundClass() {
        return List.class;
    }

    protected abstract Collection<T> parse(String var1, String var2, PropertyContext var3, ObjectFactory<T> var4);

    protected abstract List<T> createList();
}

