/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led.factory.object;

import be.objectify.led.FactoryResolver;
import be.objectify.led.ObjectFactory;
import be.objectify.led.PropertyContext;
import be.objectify.led.factory.object.AbstractObjectFactory;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapFactory<K, V>
extends AbstractObjectFactory<Map> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapFactory.class);
    private final Class keyClass;
    private final Class valueClass;
    private final Field field;
    private final FactoryResolver factoryResolver;

    public MapFactory(Class keyClass, Class valueClass, Field field, FactoryResolver factoryResolver) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.field = field;
        this.factoryResolver = factoryResolver;
    }

    @Override
    public Map<K, V> createObject(String propertyName, String propertyValue, PropertyContext propertyContext) {
        Map<K, V> map = this.createMap();
        ObjectFactory keyObjectFactory = this.factoryResolver.resolveFactory(this.keyClass, this.field);
        ObjectFactory valueObjectFactory = this.factoryResolver.resolveFactory(this.valueClass, this.field);
        if (keyObjectFactory == null || valueObjectFactory == null) {
            LOGGER.info("No factory available for map: key factory [{}]   value factory [{}]", (Object)this.keyClass.getCanonicalName(), (Object)this.valueClass.getCanonicalName());
        } else {
            Map<K, V> values = this.parse(propertyName, propertyValue, propertyContext, keyObjectFactory, valueObjectFactory);
            if (values != null) {
                map.putAll(values);
            } else {
                LOGGER.info("Property value [{}] did not parse into map of type [{}][{}]", new Object[]{propertyValue, this.keyClass.getCanonicalName(), this.valueClass.getCanonicalName()});
            }
        }
        return map;
    }

    @Override
    public Class<Map> getBoundClass() {
        return Map.class;
    }

    protected abstract Map<K, V> parse(String var1, String var2, PropertyContext var3, ObjectFactory<K> var4, ObjectFactory<V> var5);

    protected abstract Map<K, V> createMap();
}

