/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led.factory.type;

import be.objectify.led.FactoryResolver;
import be.objectify.led.GenericTypes;
import be.objectify.led.ObjectFactory;
import be.objectify.led.PropertyContext;
import be.objectify.led.TypeFactory;
import be.objectify.led.factory.object.MapFactory;
import be.objectify.led.util.StringUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTypeFactory
implements TypeFactory<Map> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapTypeFactory.class);
    private final FactoryResolver factoryResolver;

    public MapTypeFactory(FactoryResolver factoryResolver) {
        this.factoryResolver = factoryResolver;
    }

    public MapFactory createObjectFactory(Class[] classes, Field field) {
        return new MapFactory(classes[0], classes[1], field, this.factoryResolver){

            protected Map parse(String propertyName, String propertyValue, PropertyContext propertyContext, ObjectFactory keyObjectFactory, ObjectFactory valueObjectFactory) {
                HashMap map = new HashMap();
                if (!StringUtils.isEmpty(propertyValue)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(propertyValue);
                    while (stringTokenizer.hasMoreTokens()) {
                        String s = stringTokenizer.nextToken();
                        String[] strings = s.split(":");
                        if (strings.length == 2) {
                            map.put(keyObjectFactory.createObject(propertyName, strings[0], propertyContext), valueObjectFactory.createObject(propertyName, strings[1], propertyContext));
                            continue;
                        }
                        LOGGER.error("Could not separate [{}] into key:value", (Object)propertyValue);
                    }
                }
                return map;
            }

            protected Map createMap() {
                return new HashMap();
            }
        };
    }

    @Override
    public Class<Map> getBoundClass() {
        return Map.class;
    }

    @Override
    public Class[] determineClassType(Class fieldType, GenericTypes genericTypes) {
        if (genericTypes == null || genericTypes.value().length != 2) {
            throw new RuntimeException("GenericTypes(key class, value class) annotation required to determine Map key:value types");
        }
        Class[] classes = genericTypes.value();
        return new Class[]{classes[0], classes[1]};
    }
}

