/*
 * Decompiled with CFR 0.152.
 */
package be.objectify.led.factory.type;

import be.objectify.led.FactoryResolver;
import be.objectify.led.GenericTypes;
import be.objectify.led.ObjectFactory;
import be.objectify.led.PropertyContext;
import be.objectify.led.TypeFactory;
import be.objectify.led.factory.object.SetFactory;
import be.objectify.led.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTypeFactory
implements TypeFactory<Set> {
    private final FactoryResolver factoryResolver;

    public SetTypeFactory(FactoryResolver factoryResolver) {
        this.factoryResolver = factoryResolver;
    }

    public SetFactory createObjectFactory(Class[] classes, Field field) {
        return new SetFactory(classes[0], field, this.factoryResolver){

            protected Collection parse(String propertyName, String propertyValue, PropertyContext propertyContext, ObjectFactory objectFactory) {
                ArrayList list = new ArrayList();
                if (!StringUtils.isEmpty(propertyValue)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(propertyValue);
                    while (stringTokenizer.hasMoreTokens()) {
                        list.add(objectFactory.createObject(propertyName, stringTokenizer.nextToken(), propertyContext));
                    }
                }
                return list;
            }

            protected Set createSet() {
                return new HashSet();
            }
        };
    }

    @Override
    public Class<Set> getBoundClass() {
        return Set.class;
    }

    @Override
    public Class[] determineClassType(Class fieldType, GenericTypes genericTypes) {
        if (genericTypes == null || genericTypes.value().length != 1) {
            throw new RuntimeException("GenericTypes(value class) annotation required to determine Collection value type");
        }
        return genericTypes.value();
    }
}

