/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.dom.Document;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.ExpressionEvaluatorObjects;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Arguments {
    public static final String SELECTION_TARGET_LOCAL_VARIABLE_NAME = "%%{SELECTION_TARGET}%%";
    private final TemplateProcessingParameters templateProcessingParameters;
    private final Configuration configuration;
    private final Document document;
    private final TemplateResolution templateResolution;
    private final TemplateRepository templateRepository;
    private final IContext context;
    private final HashMap<String, Object> localVariables;
    private final Map<String, Integer> idCounts;
    private final Object evaluationRoot;
    private final Object selectionEvaluationRoot;
    private final boolean processOnlyElementNodes;
    private final Map<String, Object> baseContextVariables;

    Arguments(TemplateProcessingParameters templateProcessingParameters, TemplateResolution templateResolution, TemplateRepository templateRepository, Document document) {
        Validate.notNull(templateProcessingParameters, "Template processing parameters cannot be null");
        Validate.notNull(templateResolution, "Template resolution cannot be null");
        Validate.notNull(templateRepository, "Template repository cannot be null");
        Validate.notNull(document, "Document cannot be null");
        this.templateProcessingParameters = templateProcessingParameters;
        this.configuration = this.templateProcessingParameters.getConfiguration();
        this.templateResolution = templateResolution;
        this.templateRepository = templateRepository;
        this.document = document;
        this.context = this.templateProcessingParameters.getContext();
        this.localVariables = null;
        this.idCounts = new HashMap<String, Integer>();
        this.evaluationRoot = this.createEvaluationRoot();
        this.selectionEvaluationRoot = this.createSelectedEvaluationRoot();
        this.processOnlyElementNodes = true;
        this.baseContextVariables = ExpressionEvaluatorObjects.computeEvaluationVariablesForArguments(this);
    }

    private Arguments(TemplateProcessingParameters templateProcessingParameters, TemplateResolution templateResolution, TemplateRepository templateRepository, Document document, HashMap<String, Object> localVariables, Map<String, Integer> idCounts, boolean processOnlyElementNodes) {
        this.templateProcessingParameters = templateProcessingParameters;
        this.configuration = this.templateProcessingParameters.getConfiguration();
        this.templateResolution = templateResolution;
        this.templateRepository = templateRepository;
        this.document = document;
        this.context = this.templateProcessingParameters.getContext();
        this.localVariables = localVariables;
        this.idCounts = idCounts;
        this.evaluationRoot = this.createEvaluationRoot();
        this.selectionEvaluationRoot = this.createSelectedEvaluationRoot();
        this.processOnlyElementNodes = processOnlyElementNodes;
        this.baseContextVariables = ExpressionEvaluatorObjects.computeEvaluationVariablesForArguments(this);
    }

    private Object createEvaluationRoot() {
        VariablesMap<String, Object> newEvaluationRoot = new VariablesMap<String, Object>();
        newEvaluationRoot.putAll(this.context.getVariables());
        if (this.hasLocalVariables()) {
            newEvaluationRoot.putAll(this.localVariables);
        }
        return newEvaluationRoot;
    }

    private Object createSelectedEvaluationRoot() {
        if (this.hasSelectionTarget()) {
            return this.getSelectionTarget();
        }
        return this.evaluationRoot;
    }

    public TemplateProcessingParameters getTemplateProcessingParameters() {
        return this.templateProcessingParameters;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TemplateResolution getTemplateResolution() {
        return this.templateResolution;
    }

    public TemplateRepository getTemplateRepository() {
        return this.templateRepository;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getTemplateName() {
        return this.templateResolution.getTemplateName();
    }

    public IContext getContext() {
        return this.context;
    }

    public boolean hasLocalVariables() {
        return this.localVariables != null && this.localVariables.size() > 0;
    }

    public Object getLocalVariable(String variableName) {
        if (this.localVariables == null) {
            return null;
        }
        return this.localVariables.get(variableName);
    }

    public boolean hasLocalVariable(String variableName) {
        if (this.localVariables == null) {
            return false;
        }
        return this.localVariables.containsKey(variableName);
    }

    public HashMap<String, Object> unsafeGetLocalVariables() {
        return this.localVariables;
    }

    public Map<String, Object> getLocalVariables() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        if (this.localVariables != null) {
            vars.putAll(this.localVariables);
        }
        return vars;
    }

    public boolean getProcessOnlyElementNodes() {
        return this.processOnlyElementNodes;
    }

    public boolean hasSelectionTarget() {
        return this.hasLocalVariable(SELECTION_TARGET_LOCAL_VARIABLE_NAME);
    }

    public Object getSelectionTarget() {
        if (this.hasSelectionTarget()) {
            return this.getLocalVariable(SELECTION_TARGET_LOCAL_VARIABLE_NAME);
        }
        throw new IllegalStateException("Cannot return selection target object, a selection target has not been set.");
    }

    public Map<String, Integer> getIdCounts() {
        return this.idCounts;
    }

    public Map<String, Object> getExecutionAttributes() {
        return this.configuration.getExecutionAttributes();
    }

    public Object getExecutionAttribute(String attributeName) {
        return this.configuration.getExecutionAttributes().get(attributeName);
    }

    public Object getExpressionEvaluationRoot() {
        return this.evaluationRoot;
    }

    public Object getExpressionSelectionEvaluationRoot() {
        return this.selectionEvaluationRoot;
    }

    public Map<String, Object> getBaseContextVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(this.baseContextVariables);
        return variables;
    }

    public Integer getAndIncrementIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            count = 1;
        }
        this.idCounts.put(id, count + 1);
        return count;
    }

    public Integer getNextIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            count = 1;
        }
        return count;
    }

    public Integer getPreviousIDSeq(String id) {
        Validate.notNull(id, "ID cannot be null");
        Integer count = this.idCounts.get(id);
        if (count == null) {
            throw new TemplateProcessingException("Cannot obtain previous ID count for ID \"" + id + "\"");
        }
        return count - 1;
    }

    public Arguments addLocalVariables(Map<String, Object> newVariables) {
        if (newVariables == null || newVariables.isEmpty()) {
            return this;
        }
        int localVariablesSize = this.localVariables != null ? this.localVariables.size() : 0;
        HashMap<String, Object> cloneLocalVariables = new HashMap<String, Object>(localVariablesSize + newVariables.size() + 1, 1.0f);
        if (this.localVariables != null) {
            cloneLocalVariables.putAll(this.localVariables);
        }
        cloneLocalVariables.putAll(newVariables);
        Arguments arguments = new Arguments(this.templateProcessingParameters, this.templateResolution, this.templateRepository, this.document, cloneLocalVariables, this.idCounts, this.processOnlyElementNodes);
        return arguments;
    }

    public Arguments setProcessOnlyElementNodes(boolean shouldProcessOnlyElementNodes) {
        Arguments arguments = new Arguments(this.templateProcessingParameters, this.templateResolution, this.templateRepository, this.document, this.localVariables, this.idCounts, shouldProcessOnlyElementNodes);
        return arguments;
    }

    public Arguments addLocalVariablesAndProcessOnlyElementNodes(Map<String, Object> newVariables, boolean shouldProcessOnlyElementNodes) {
        if (newVariables == null || newVariables.isEmpty()) {
            return this;
        }
        int localVariablesSize = this.localVariables != null ? this.localVariables.size() : 0;
        HashMap<String, Object> cloneLocalVariables = new HashMap<String, Object>(localVariablesSize + newVariables.size() + 1, 1.0f);
        if (this.localVariables != null) {
            cloneLocalVariables.putAll(this.localVariables);
        }
        cloneLocalVariables.putAll(newVariables);
        Arguments arguments = new Arguments(this.templateProcessingParameters, this.templateResolution, this.templateRepository, this.document, cloneLocalVariables, this.idCounts, shouldProcessOnlyElementNodes);
        return arguments;
    }
}

