/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.Serializable;
import org.thymeleaf.Configuration;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.doctype.translation.IDocTypeTranslation;
import org.thymeleaf.util.Validate;
import org.w3c.dom.DocumentType;

public final class DocType
implements Serializable {
    private static final long serialVersionUID = -5122946925754578948L;
    private final String rootElementName;
    private final String publicId;
    private final String systemId;
    private boolean processed;
    private DocTypeIdentifier processedPublicId;
    private DocTypeIdentifier processedSystemId;

    public DocType(String rootElementName, String publicId, String systemId) {
        Validate.notNull(rootElementName, "Root element name cannot be null");
        this.rootElementName = rootElementName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.processed = false;
        this.processedPublicId = null;
        this.processedSystemId = null;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public DocTypeIdentifier getProcessedPublicId() {
        return this.processedPublicId;
    }

    public DocTypeIdentifier getProcessedSystemId() {
        return this.processedSystemId;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void process(Configuration configuration) {
        IDocTypeTranslation translation;
        if (!this.processed && (translation = configuration.getDocTypeTranslationBySource(this.publicId, this.systemId)) != null) {
            this.processedPublicId = translation.getTargetPublicID();
            this.processedSystemId = translation.getTargetSystemID();
            this.processed = true;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rootElementName.hashCode();
        result = 31 * result + (this.publicId == null ? 0 : this.publicId.hashCode());
        result = 31 * result + (this.systemId == null ? 0 : this.systemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocType other = (DocType)obj;
        if (!this.rootElementName.equals(other.rootElementName)) {
            return false;
        }
        if (this.publicId == null ? other.publicId != null : !this.publicId.equals(other.publicId)) {
            return false;
        }
        return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
    }

    public static final DocType translateDOMDocumentType(DocumentType domDocumentType) {
        if (domDocumentType == null) {
            return null;
        }
        String rootElementName = domDocumentType.getName();
        return new DocType(rootElementName, domDocumentType.getPublicId(), domDocumentType.getSystemId());
    }
}

