/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorResult {
    private static final Map<String, Object> EMPTY_VARIABLES = Collections.unmodifiableMap(new HashMap());
    public static final ProcessorResult OK = new ProcessorResult(null, false, false);
    private final Map<String, Object> localVariables;
    private final boolean processOnlyElementNodes;
    private final boolean processOnlyElementNodesSet;

    public static ProcessorResult ok() {
        return OK;
    }

    public static ProcessorResult setLocalVariables(Map<String, Object> localVariables) {
        return new ProcessorResult(localVariables, false, false);
    }

    public static ProcessorResult setProcessOnlyElementNodes(boolean processOnlyElementNodes) {
        return new ProcessorResult(null, processOnlyElementNodes, true);
    }

    public static ProcessorResult setLocalVariablesAndProcessOnlyElementNodes(Map<String, Object> localVariables, boolean processOnlyElementNodes) {
        return new ProcessorResult(localVariables, processOnlyElementNodes, true);
    }

    private ProcessorResult(Map<String, Object> localVariables, boolean processOnlyElementNodes, boolean processOnlyElementNodesSet) {
        this.localVariables = localVariables == null ? EMPTY_VARIABLES : Collections.unmodifiableMap(new HashMap<String, Object>(localVariables));
        this.processOnlyElementNodes = processOnlyElementNodes;
        this.processOnlyElementNodesSet = processOnlyElementNodesSet;
    }

    public boolean hasLocalVariables() {
        return this.localVariables != null && this.localVariables.size() > 0;
    }

    public Map<String, Object> getLocalVariables() {
        return this.localVariables;
    }

    public boolean getProcessOnlyElementNodes() {
        return this.processOnlyElementNodes;
    }

    public boolean isProcessOnlyElementNodesSet() {
        return this.processOnlyElementNodesSet;
    }

    public boolean isOK() {
        return (this.localVariables == null || this.localVariables.size() == 0) && !this.processOnlyElementNodesSet;
    }

    public Arguments computeNewArguments(Arguments arguments) {
        if (this.isOK()) {
            return arguments;
        }
        if (this.localVariables != null && this.localVariables.size() > 0) {
            if (this.processOnlyElementNodesSet) {
                return arguments.addLocalVariablesAndProcessOnlyElementNodes(this.localVariables, this.processOnlyElementNodes);
            }
            return arguments.addLocalVariables(this.localVariables);
        }
        if (this.processOnlyElementNodesSet) {
            return arguments.setProcessOnlyElementNodes(this.processOnlyElementNodes);
        }
        return arguments;
    }
}

