/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.attr;

import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

public abstract class AbstractIterationAttrProcessor
extends AbstractAttrProcessor {
    public static final String DEFAULT_STATUS_VAR_SUFFIX = "Stat";

    public AbstractIterationAttrProcessor(String attributeName) {
        super(attributeName);
    }

    public AbstractIterationAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        NestableNode parentNode = element.getParent();
        IterationSpec iterationSpec = this.getIterationSpec(arguments, element, attributeName);
        String iterVar = iterationSpec.getIterVarName();
        String statusVar = iterationSpec.getStatusVarName();
        Object iteratedObject = iterationSpec.getIteratedObject();
        List<Object> list = ObjectUtils.convertToList(iteratedObject);
        int size = list.size();
        int index = 0;
        for (Object obj : list) {
            Element clonedElement = (Element)element.cloneNode(parentNode, false);
            clonedElement.removeAttribute(attributeName);
            clonedElement.setNodeLocalVariable(iterVar, obj);
            StatusVar status = new StatusVar(index, index + 1, size, obj);
            if (statusVar != null) {
                clonedElement.setNodeLocalVariable(statusVar, status);
            } else {
                clonedElement.setNodeLocalVariable(iterVar + DEFAULT_STATUS_VAR_SUFFIX, status);
            }
            parentNode.insertBefore(element, clonedElement);
            this.processClonedHostIterationElement(arguments, clonedElement, attributeName);
            ++index;
        }
        parentNode.removeChild(element);
        return ProcessorResult.OK;
    }

    protected abstract IterationSpec getIterationSpec(Arguments var1, Element var2, String var3);

    protected abstract void processClonedHostIterationElement(Arguments var1, Element var2, String var3);

    protected static class IterationSpec {
        private final String iterVarName;
        private final String statusVarName;
        private final Object iteratedObject;

        public IterationSpec(String iterVarName, String statusVarName, Object iteratedObject) {
            Validate.notEmpty(iterVarName, "Iteration var name cannot be null or empty");
            this.iterVarName = iterVarName;
            this.statusVarName = statusVarName;
            this.iteratedObject = iteratedObject;
        }

        public String getIterVarName() {
            return this.iterVarName;
        }

        public String getStatusVarName() {
            return this.statusVarName;
        }

        public Object getIteratedObject() {
            return this.iteratedObject;
        }
    }

    public static class StatusVar {
        private final int index;
        private final int count;
        private final int size;
        private final Object current;

        public StatusVar(int index, int count, int size, Object current) {
            this.index = index;
            this.count = count;
            this.size = size;
            this.current = current;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.count;
        }

        public int getSize() {
            return this.size;
        }

        public Object getCurrent() {
            return this.current;
        }

        public boolean isEven() {
            return this.index % 2 == 0;
        }

        public boolean isOdd() {
            return !this.isEven();
        }

        public boolean isFirst() {
            return this.index == 0;
        }

        public boolean isLast() {
            return this.index == this.size - 1;
        }

        public String toString() {
            return "{index = " + this.index + ", count = " + this.count + ", size = " + this.size + ", current = " + (this.current == null ? "null" : this.current.toString()) + "}";
        }
    }
}

