/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor.element;

import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.element.AbstractElementProcessor;

public abstract class AbstractConditionalVisibilityElementProcessor
extends AbstractElementProcessor {
    public AbstractConditionalVisibilityElementProcessor(String elementName) {
        super(elementName);
    }

    public AbstractConditionalVisibilityElementProcessor(IElementNameProcessorMatcher matcher) {
        super(matcher);
    }

    public final ProcessorResult processElement(Arguments arguments, Element element) {
        boolean visible = this.isVisible(arguments, element);
        boolean removeHostElementIfVisible = this.removeHostElementIfVisible(arguments, element);
        NestableNode parent = element.getParent();
        if (!visible) {
            element.clearChildren();
            parent.removeChild(element);
            return ProcessorResult.OK;
        }
        if (removeHostElementIfVisible) {
            parent.extractChild(element);
        }
        return ProcessorResult.OK;
    }

    protected abstract boolean isVisible(Arguments var1, Element var2);

    protected abstract boolean removeHostElementIfVisible(Arguments var1, Element var2);
}

