/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.standard.expression.BinaryOperationExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AndExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -6085038102412415337L;
    private static final Logger logger = LoggerFactory.getLogger(AndExpression.class);
    private static final String OPERATOR = "and";
    private static final String[] OPERATORS = new String[]{"and"};
    private static final boolean[] LENIENCIES = new boolean[]{false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{AndExpression.class};

    public AndExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public String getStringRepresentation() {
        return this.getStringRepresentation(OPERATOR);
    }

    protected static List<ExpressionParsingNode> composeAndExpression(List<ExpressionParsingNode> decomposition, int inputIndex) {
        return AndExpression.composeBinaryOperationExpression(decomposition, inputIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES);
    }

    static Object executeAnd(Arguments arguments, AndExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating AND expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Object leftValue = Expression.execute(arguments, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(arguments, expression.getRight(), expressionEvaluator);
        boolean leftBooleanValue = ObjectUtils.evaluateAsBoolean(leftValue);
        boolean rightBooleanValue = ObjectUtils.evaluateAsBoolean(rightValue);
        return leftBooleanValue && rightBooleanValue;
    }
}

