/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConditionalExpression
extends ComplexExpression {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalExpression.class);
    private static final long serialVersionUID = -6966177717462316363L;
    private static final char CONDITION_SUFFIX_CHAR = '?';
    private static final char CONDITION_THENELSE_SEPARATOR_CHAR = ':';
    private final Expression conditionExpression;
    private final Expression thenExpression;
    private final Expression elseExpression;

    public ConditionalExpression(Expression conditionExpression, Expression thenExpression, Expression elseExpression) {
        Validate.notNull(conditionExpression, "Condition expression cannot be null");
        Validate.notNull(thenExpression, "Then expression cannot be null");
        Validate.notNull(elseExpression, "Else expression cannot be null");
        this.conditionExpression = conditionExpression;
        this.thenExpression = thenExpression;
        this.elseExpression = elseExpression;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public Expression getThenExpression() {
        return this.thenExpression;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.conditionExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.conditionExpression);
            sb.append(')');
        } else {
            sb.append(this.conditionExpression);
        }
        sb.append('?');
        sb.append(' ');
        if (this.thenExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.thenExpression);
            sb.append(')');
        } else {
            sb.append(this.thenExpression);
        }
        sb.append(' ');
        sb.append(':');
        sb.append(' ');
        if (this.elseExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.elseExpression);
            sb.append(')');
        } else {
            sb.append(this.elseExpression);
        }
        return sb.toString();
    }

    static List<ExpressionParsingNode> composeConditionalExpression(List<ExpressionParsingNode> decomposition, int inputIndex) {
        ExpressionParsingNode inputParsingNode = decomposition.get(inputIndex);
        List<ExpressionParsingNode> result = decomposition;
        String input = inputParsingNode.getInput();
        if (input == null || input.trim().equals("")) {
            return null;
        }
        int condSuffixPos = input.indexOf(63);
        if (condSuffixPos == -1) {
            return result;
        }
        String condStr = input.substring(0, condSuffixPos);
        String remainder = input.substring(condSuffixPos + 1);
        if (remainder.indexOf(63) != -1) {
            return null;
        }
        int thenElseSepPos = remainder.indexOf(58);
        if (remainder.lastIndexOf(58) != thenElseSepPos) {
            return null;
        }
        String thenStr = null;
        String elseStr = null;
        if (thenElseSepPos != -1) {
            if (thenElseSepPos == 0) {
                return result;
            }
            thenStr = remainder.substring(0, thenElseSepPos);
            elseStr = remainder.substring(thenElseSepPos + 1);
        } else {
            thenStr = remainder;
        }
        int condIndex = Expression.placeHolderToIndex(condStr);
        if (condIndex == -1) {
            List<ExpressionParsingNode> newResult = new ArrayList<ExpressionParsingNode>(result);
            condIndex = newResult.size();
            newResult.add(new ExpressionParsingNode(condStr));
            newResult = ComplexExpression.composeComplexExpressions(newResult, condIndex);
            if (newResult == null) {
                return null;
            }
            result = newResult;
        } else if ((result = ComplexExpression.composeComplexExpressions(result, condIndex)) == null) {
            return null;
        }
        int thenIndex = Expression.placeHolderToIndex(thenStr);
        if (thenIndex == -1) {
            List<ExpressionParsingNode> newResult = new ArrayList<ExpressionParsingNode>(result);
            thenIndex = newResult.size();
            newResult.add(new ExpressionParsingNode(thenStr));
            newResult = ComplexExpression.composeComplexExpressions(newResult, thenIndex);
            if (newResult == null) {
                return null;
            }
            result = newResult;
        } else if ((result = ComplexExpression.composeComplexExpressions(result, thenIndex)) == null) {
            return null;
        }
        ExpressionParsingNode condEPN = result.get(condIndex);
        Expression condExpr = condEPN.getExpression();
        if (condExpr == null) {
            return null;
        }
        ExpressionParsingNode thenEPN = result.get(thenIndex);
        Expression thenExpr = thenEPN.getExpression();
        if (thenExpr == null) {
            return null;
        }
        Expression elseExpr = VariableExpression.NULL_VALUE;
        if (elseStr != null) {
            int elseIndex = Expression.placeHolderToIndex(elseStr);
            if (elseIndex == -1) {
                List<ExpressionParsingNode> newResult = new ArrayList<ExpressionParsingNode>(result);
                elseIndex = newResult.size();
                newResult.add(new ExpressionParsingNode(elseStr));
                newResult = ComplexExpression.composeComplexExpressions(newResult, elseIndex);
                if (newResult == null) {
                    return null;
                }
                result = newResult;
            } else if ((result = ComplexExpression.composeComplexExpressions(result, elseIndex)) == null) {
                return null;
            }
            ExpressionParsingNode elseEPN = result.get(elseIndex);
            elseExpr = elseEPN.getExpression();
            if (elseExpr == null) {
                return null;
            }
        }
        ConditionalExpression conditionalExpressionResult = new ConditionalExpression(condExpr, thenExpr, elseExpr);
        result.set(inputIndex, new ExpressionParsingNode(conditionalExpressionResult));
        return result;
    }

    static Object executeConditional(Arguments arguments, ConditionalExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        Object condObj;
        boolean cond;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating conditional expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if (cond = ObjectUtils.evaluateAsBoolean(condObj = Expression.execute(arguments, expression.getConditionExpression(), expressionEvaluator))) {
            return Expression.execute(arguments, expression.getThenExpression(), expressionEvaluator);
        }
        return Expression.execute(arguments, expression.getElseExpression(), expressionEvaluator);
    }
}

