/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionSequence
implements Iterable<Expression>,
Serializable {
    private static final long serialVersionUID = -6069208208568731809L;
    private static final char SEQUENCE_SEPARATOR_CHAR = ',';
    private final List<Expression> expressions;

    public ExpressionSequence(List<? extends Expression> expressions) {
        Validate.notNull(expressions, "Expression list cannot be null");
        Validate.containsNoNulls(expressions, "Expression list cannot contain any nulls");
        this.expressions = Collections.unmodifiableList(expressions);
    }

    public List<Expression> getExpression() {
        return this.expressions;
    }

    public int size() {
        return this.expressions.size();
    }

    @Override
    public Iterator<Expression> iterator() {
        return this.expressions.iterator();
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.expressions.size() > 0) {
            sb.append(this.expressions.get(0));
            for (int i = 1; i < this.expressions.size(); ++i) {
                sb.append(',');
                sb.append(this.expressions.get(i));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    static ExpressionSequence parse(String input) {
        if (input == null || input.trim().equals("")) {
            return null;
        }
        List<ExpressionParsingNode> result = SimpleExpression.decomposeSimpleExpressions(input);
        if (result == null) {
            return null;
        }
        if ((result = ExpressionSequence.composeSequence(result, 0)) == null || !result.get(0).isExpressionSequence()) {
            return null;
        }
        return result.get(0).getExpressionSequence();
    }

    private static List<ExpressionParsingNode> composeSequence(List<ExpressionParsingNode> inputExprs, int inputIndex) {
        if (inputExprs == null || inputExprs.size() == 0 || inputIndex >= inputExprs.size()) {
            return null;
        }
        String input = inputExprs.get(inputIndex).getInput();
        StringBuilder inputWithPlaceholders = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        ArrayList<ExpressionParsingNode> fragments = new ArrayList<ExpressionParsingNode>();
        int currentIndex = inputExprs.size();
        ArrayList<Integer> expressionIndexes = new ArrayList<Integer>();
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (c == ',') {
                if (fragments.size() > 0) {
                    inputWithPlaceholders.append(',');
                }
                expressionIndexes.add(currentIndex);
                inputWithPlaceholders.append('\u00a7');
                inputWithPlaceholders.append(String.valueOf(currentIndex++));
                inputWithPlaceholders.append('\u00a7');
                fragments.add(new ExpressionParsingNode(fragment.toString()));
                fragment = new StringBuilder();
                continue;
            }
            fragment.append(c);
        }
        if (fragments.size() > 0) {
            inputWithPlaceholders.append(',');
        }
        expressionIndexes.add(currentIndex);
        inputWithPlaceholders.append('\u00a7');
        inputWithPlaceholders.append(String.valueOf(currentIndex++));
        inputWithPlaceholders.append('\u00a7');
        fragments.add(new ExpressionParsingNode(fragment.toString()));
        List<ExpressionParsingNode> result = inputExprs;
        result.set(inputIndex, new ExpressionParsingNode(inputWithPlaceholders.toString()));
        result.addAll(fragments);
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Integer expressionIndex : expressionIndexes) {
            int expressionIdx = expressionIndex;
            if ((result = Expression.unnest(result, expressionIdx)) == null) {
                return null;
            }
            if (!result.get(expressionIdx).isExpression()) {
                if ((result = ComplexExpression.composeComplexExpressions(result, expressionIdx)) == null) {
                    return null;
                }
                if (!result.get(expressionIdx).isExpression()) {
                    return null;
                }
            }
            expressions.add(result.get(expressionIdx).getExpression());
        }
        ExpressionSequence expressionSequence = new ExpressionSequence(expressions);
        result.set(inputIndex, new ExpressionParsingNode(expressionSequence));
        return result;
    }
}

