/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.util.ObjectUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NegationExpression
extends ComplexExpression {
    private static final long serialVersionUID = -7131967162611145337L;
    private static final Logger logger = LoggerFactory.getLogger(NegationExpression.class);
    private static final char OPERATOR = '!';
    private final Expression operand;

    public NegationExpression(Expression operand) {
        Validate.notNull(operand, "Operand cannot be null");
        this.operand = operand;
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('!');
        if (this.operand instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.operand);
            sb.append(')');
        } else {
            sb.append(this.operand);
        }
        return sb.toString();
    }

    public static List<ExpressionParsingNode> composeNegationExpression(List<ExpressionParsingNode> decomposition, int inputIndex) {
        ExpressionParsingNode epn;
        Expression expr;
        ExpressionParsingNode inputParsingNode = decomposition.get(inputIndex);
        List<ExpressionParsingNode> result = decomposition;
        String input = inputParsingNode.getInput();
        if (input == null || input.trim().equals("")) {
            return null;
        }
        String trimmedInput = input.trim();
        int operatorPos = trimmedInput.lastIndexOf(33);
        if (operatorPos == -1) {
            return result;
        }
        if (operatorPos != 0) {
            return result;
        }
        String operandStr = trimmedInput.substring(1);
        int index = Expression.placeHolderToIndex(operandStr);
        if (index == -1) {
            index = result.size();
            result.add(new ExpressionParsingNode(operandStr));
            result = ComplexExpression.composeComplexExpressions(result, index);
            if (result == null) {
                return null;
            }
        } else if ((result = ComplexExpression.composeComplexExpressions(result, index)) == null) {
            return null;
        }
        if ((expr = (epn = result.get(index)).getExpression()) == null) {
            return null;
        }
        NegationExpression minusExpression = new NegationExpression(expr);
        result.set(inputIndex, new ExpressionParsingNode(minusExpression));
        return result;
    }

    static Object executeNegation(Arguments arguments, NegationExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        Object operandValue;
        boolean operandBooleanValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating negation expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return !(operandBooleanValue = ObjectUtils.evaluateAsBoolean(operandValue = Expression.execute(arguments, expression.getOperand(), expressionEvaluator)));
    }
}

