/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.inliner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.AbstractTextNode;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;
import org.thymeleaf.standard.inliner.IStandardTextInliner;

public abstract class AbstractStandardScriptingTextInliner
implements IStandardTextInliner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SCRIPT_ADD_INLINE_EVAL = "\\/\\*\\[\\+(.*?)\\+\\]\\*\\/";
    public static final Pattern SCRIPT_ADD_INLINE_EVAL_PATTERN = Pattern.compile("\\/\\*\\[\\+(.*?)\\+\\]\\*\\/", 32);
    public static final String SCRIPT_REMOVE_INLINE_EVAL = "\\/\\*\\[\\-(.*?)\\-\\]\\*\\/";
    public static final Pattern SCRIPT_REMOVE_INLINE_EVAL_PATTERN = Pattern.compile("\\/\\*\\[\\-(.*?)\\-\\]\\*\\/", 32);
    public static final String SCRIPT_VARIABLE_EXPRESSION_INLINE_EVAL = "\\/\\*(\\[\\[(.*?)\\]\\])\\*\\/([^\n]*?)\n";
    public static final Pattern SCRIPT_VARIABLE_EXPRESSION_INLINE_EVAL_PATTERN = Pattern.compile("\\/\\*(\\[\\[(.*?)\\]\\])\\*\\/([^\n]*?)\n", 32);
    public static final String SCRIPT_INLINE_EVAL = "\\[\\[(.*?)\\]\\]";
    public static final Pattern SCRIPT_INLINE_EVAL_PATTERN = Pattern.compile("\\[\\[(.*?)\\]\\]", 32);

    protected AbstractStandardScriptingTextInliner() {
    }

    public final void inline(Arguments arguments, AbstractTextNode text) {
        String content = text.getContent();
        String javascriptContent = this.processScriptingInline(content, arguments);
        text.setContent(javascriptContent);
    }

    private final String processScriptingInline(String input, Arguments arguments) {
        return this.processScriptingVariableInline(this.processScriptingVariableExpressionInline(this.processScriptingAddInline(this.processScriptingRemoveInline(input))), arguments);
    }

    private final String processScriptingAddInline(String input) {
        Matcher matcher = SCRIPT_ADD_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                String match = matcher.group(1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[THYMELEAF][{}] Adding inlined javascript text \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)match);
                }
                strBuilder.append(match);
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    private final String processScriptingRemoveInline(String input) {
        Matcher matcher = SCRIPT_REMOVE_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                String match = matcher.group(1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[THYMELEAF][{}] Removing inlined javascript text \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)match);
                }
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    private final String processScriptingVariableExpressionInline(String input) {
        Matcher matcher = SCRIPT_VARIABLE_EXPRESSION_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                strBuilder.append(matcher.group(1));
                strBuilder.append(';');
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    private final String processScriptingVariableInline(String input, Arguments arguments) {
        Matcher matcher = SCRIPT_INLINE_EVAL_PATTERN.matcher(input);
        if (matcher.find()) {
            StringBuilder strBuilder = new StringBuilder();
            int curr = 0;
            do {
                strBuilder.append(input.substring(curr, matcher.start(0)));
                String match = matcher.group(1);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("[THYMELEAF][{}] Applying javascript variable inline evaluation on \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)match);
                }
                try {
                    Object result = StandardExpressionProcessor.processExpression(arguments, match);
                    strBuilder.append(this.formatEvaluationResult(result));
                }
                catch (TemplateProcessingException e) {
                    strBuilder.append(match);
                }
                curr = matcher.end(0);
            } while (matcher.find());
            strBuilder.append(input.substring(curr));
            return strBuilder.toString();
        }
        return input;
    }

    protected abstract String formatEvaluationResult(Object var1);
}

