/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.xmldom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ParserInitializationException;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templateparser.EntityResolver;
import org.thymeleaf.templateparser.EntitySubstitutionTemplateReader;
import org.thymeleaf.templateparser.ErrorHandler;
import org.thymeleaf.templateparser.ITemplateParser;
import org.thymeleaf.util.ResourcePool;
import org.thymeleaf.util.StandardDOMTranslator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNonValidatingDOMTemplateParser
implements ITemplateParser {
    private static final String SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT = "The content of elements must consist of well-formed character data or markup.";
    private static final String SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT_EXPLANATION = "The content of elements must consist of well-formed character data or markup. A usual reason for this is that one of your elements contains unescaped special XML symbols like '<' inside its body, which is forbidden by XML rules. For example, if you have '<' inside a <script> tag, you should surround your script body with commented CDATA markers (like '/* <![CDATA[ */' and '/* ]]> */')";
    private ResourcePool<DocumentBuilder> pool;

    protected AbstractNonValidatingDOMTemplateParser(int poolSize) {
        this.pool = this.createDocumentBuilders(poolSize, false);
    }

    protected ResourcePool<DocumentBuilder> getPool() {
        return this.pool;
    }

    protected final ResourcePool<DocumentBuilder> getNonValidatingPool() {
        return this.pool;
    }

    protected final ResourcePool<DocumentBuilder> createDocumentBuilders(int poolSize, boolean validating) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(validating);
        ArrayList<DocumentBuilder> docBuilders = new ArrayList<DocumentBuilder>();
        for (int i = 0; i < poolSize; ++i) {
            try {
                docBuilders.add(docBuilderFactory.newDocumentBuilder());
                continue;
            }
            catch (ParserConfigurationException e) {
                throw new ParserInitializationException("Error creating document builder", e);
            }
        }
        return new ResourcePool<DocumentBuilder>(docBuilders);
    }

    @Override
    public final Document parseTemplate(Configuration configuration, String documentName, Reader reader) {
        return AbstractNonValidatingDOMTemplateParser.parseTemplateUsingPool(configuration, documentName, reader, this.getPool());
    }

    protected static final Document parseTemplateUsingPool(Configuration configuration, String documentName, Reader reader, ResourcePool<DocumentBuilder> pool) {
        DocumentBuilder docBuilder = pool.allocate();
        Reader templateReader = reader instanceof EntitySubstitutionTemplateReader ? reader : new EntitySubstitutionTemplateReader(reader, 8192);
        try {
            docBuilder.setEntityResolver(new EntityResolver(configuration));
            docBuilder.setErrorHandler(ErrorHandler.INSTANCE);
            org.w3c.dom.Document domDocument = docBuilder.parse(new InputSource(templateReader));
            docBuilder.reset();
            Document document = StandardDOMTranslator.translateDocument(domDocument, documentName);
            return document;
        }
        catch (SAXException e) {
            if (e.getMessage() != null && e.getMessage().contains(SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT)) {
                throw new TemplateInputException(SAXPARSEEXCEPTION_BAD_ELEMENT_CONTENT_EXPLANATION, e);
            }
            throw new TemplateInputException("An exception happened during parsing", e);
        }
        catch (IOException e) {
            throw new TemplateInputException("Exception parsing document", e);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateInputException("Exception parsing document", e);
        }
        finally {
            pool.release(docBuilder);
        }
    }

    @Override
    public final List<Node> parseFragment(Configuration configuration, String fragment) {
        String wrappedFragment = this.wrapFragment(fragment);
        Document document = AbstractNonValidatingDOMTemplateParser.parseTemplateUsingPool(configuration, null, new StringReader(wrappedFragment), this.getNonValidatingPool());
        return this.unwrapFragment(document);
    }

    protected abstract String wrapFragment(String var1);

    protected abstract List<Node> unwrapFragment(Document var1);
}

