/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DartUtils {
    public static String escapeString(String str) {
        StringBuilder output = new StringBuilder();
        DartUtils.escapeString(output, str);
        return output.toString();
    }

    public static String print(Object object) {
        StringBuilder output = new StringBuilder();
        DartUtils.print(output, object);
        return output.toString();
    }

    public static String printString(String str) {
        StringBuilder output = new StringBuilder();
        if (str == null) {
            DartUtils.printNull(output);
        } else {
            DartUtils.printString(output, str);
        }
        return output.toString();
    }

    public static String printNumber(Number number) {
        StringBuilder output = new StringBuilder();
        if (number == null) {
            DartUtils.printNull(output);
        } else {
            DartUtils.printNumber(output, number);
        }
        return output.toString();
    }

    public static String printBoolean(Boolean bool) {
        StringBuilder output = new StringBuilder();
        if (bool == null) {
            DartUtils.printNull(output);
        } else {
            DartUtils.printBoolean(output, bool);
        }
        return output.toString();
    }

    public static String printCollection(Collection<?> collection) {
        StringBuilder output = new StringBuilder();
        if (collection == null) {
            DartUtils.printNull(output);
        } else {
            DartUtils.printCollection(output, collection);
        }
        return output.toString();
    }

    public static String printArray(Object array) {
        StringBuilder output = new StringBuilder();
        if (array == null) {
            DartUtils.printNull(output);
        } else {
            DartUtils.printArray(output, array);
        }
        return output.toString();
    }

    public static String printMap(Map<?, ?> map) {
        StringBuilder output = new StringBuilder();
        if (map == null) {
            DartUtils.printNull(output);
        } else {
            DartUtils.printMap(output, map);
        }
        return output.toString();
    }

    public static String printObject(Object object) {
        StringBuilder output = new StringBuilder();
        if (object == null) {
            DartUtils.printNull(output);
        } else {
            DartUtils.printObject(output, object);
        }
        return output.toString();
    }

    private static void print(StringBuilder output, Object object) {
        if (object == null) {
            DartUtils.printNull(output);
            return;
        }
        if (object instanceof String) {
            DartUtils.printString(output, (String)object);
            return;
        }
        if (object instanceof Number) {
            DartUtils.printNumber(output, (Number)object);
            return;
        }
        if (object instanceof Boolean) {
            DartUtils.printBoolean(output, (Boolean)object);
            return;
        }
        if (object.getClass().isArray()) {
            DartUtils.printArray(output, object);
            return;
        }
        if (object instanceof Collection) {
            DartUtils.printCollection(output, (Collection)object);
            return;
        }
        if (object instanceof Map) {
            DartUtils.printMap(output, (Map)object);
            return;
        }
        if (object.getClass().isEnum()) {
            DartUtils.printEnum(output, object);
            return;
        }
        DartUtils.printObject(output, object);
    }

    private static void printNull(StringBuilder output) {
        output.append("null");
    }

    private static void printString(StringBuilder output, String str) {
        output.append('\'');
        DartUtils.escapeString(output, str);
        output.append('\'');
    }

    private static void printNumber(StringBuilder output, Number number) {
        output.append(number.toString());
    }

    private static void printBoolean(StringBuilder output, Boolean bool) {
        output.append(bool.toString());
    }

    private static void printArray(StringBuilder output, Object arrayObj) {
        output.append('[');
        if (arrayObj instanceof Object[]) {
            Object[] array = (Object[])arrayObj;
            boolean first = true;
            for (Object element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, element);
            }
        } else if (arrayObj instanceof boolean[]) {
            boolean[] array = (boolean[])arrayObj;
            boolean first = true;
            for (boolean element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, element);
            }
        } else if (arrayObj instanceof byte[]) {
            byte[] array = (byte[])arrayObj;
            boolean first = true;
            for (byte element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, element);
            }
        } else if (arrayObj instanceof short[]) {
            short[] array = (short[])arrayObj;
            boolean first = true;
            for (short element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, element);
            }
        } else if (arrayObj instanceof int[]) {
            int[] array = (int[])arrayObj;
            boolean first = true;
            for (int element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, element);
            }
        } else if (arrayObj instanceof long[]) {
            long[] array = (long[])arrayObj;
            boolean first = true;
            for (long element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, element);
            }
        } else if (arrayObj instanceof float[]) {
            float[] array = (float[])arrayObj;
            boolean first = true;
            for (float element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, Float.valueOf(element));
            }
        } else if (arrayObj instanceof double[]) {
            double[] array = (double[])arrayObj;
            boolean first = true;
            for (double element : array) {
                if (first) {
                    first = false;
                } else {
                    output.append(',');
                }
                DartUtils.print(output, element);
            }
        } else {
            throw new IllegalArgumentException("Cannot print \"" + arrayObj + "\" of class " + arrayObj.getClass().getName() + " as an array");
        }
        output.append(']');
    }

    private static void printCollection(StringBuilder output, Collection<?> collection) {
        output.append('[');
        boolean first = true;
        for (Object element : collection) {
            if (first) {
                first = false;
            } else {
                output.append(',');
            }
            DartUtils.print(output, element);
        }
        output.append(']');
    }

    private static void printMap(StringBuilder output, Map<?, ?> map) {
        output.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                output.append(',');
            }
            DartUtils.printKeyValue(output, entry.getKey(), entry.getValue());
        }
        output.append('}');
    }

    private static void printKeyValue(StringBuilder output, Object key, Object value) {
        DartUtils.print(output, key);
        output.append(':');
        DartUtils.print(output, value);
    }

    private static void printObject(StringBuilder output, Object object) {
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>(descriptors.length + 1, 1.0f);
            for (PropertyDescriptor descriptor : descriptors) {
                String name;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || (name = descriptor.getName()).toLowerCase().equals("class")) continue;
                Object value = readMethod.invoke(object, new Object[0]);
                properties.put(name, value);
            }
            DartUtils.printMap(output, properties);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Could not perform introspection on object of class " + object.getClass().getName(), e);
        }
    }

    private static void printEnum(StringBuilder output, Object object) {
        Enum enumObject = (Enum)object;
        Class<?> enumClass = object.getClass();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(3, 1.0f);
        properties.put("$type", enumClass.getSimpleName());
        properties.put("$name", enumObject.name());
        DartUtils.printMap(output, properties);
    }

    private static void escapeString(StringBuilder output, String str) {
        if (str == null) {
            return;
        }
        int length = str.length();
        block12: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c > '\u0fff') {
                output.append("\\u" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                output.append("\\u0" + Integer.toHexString(c));
                continue;
            }
            if (c > '\u007f') {
                output.append("\\u00" + Integer.toHexString(c));
                continue;
            }
            if (c < ' ') {
                switch (c) {
                    case '\n': {
                        output.append("\\n");
                        break;
                    }
                    case '\r': {
                        output.append("\\r");
                        break;
                    }
                    case '\t': {
                        output.append("\\t");
                        break;
                    }
                    case '\b': {
                        output.append("\\b");
                        break;
                    }
                    case '\f': {
                        output.append("\\f");
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            output.append("\\u00" + Integer.toHexString(c));
                            break;
                        }
                        output.append("\\u000" + Integer.toHexString(c));
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\'': {
                    output.append("\\'");
                    continue block12;
                }
                case '\"': {
                    output.append("\\\"");
                    continue block12;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block12;
                }
                default: {
                    output.append(c);
                }
            }
        }
    }

    private DartUtils() {
    }
}

