/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListUtils {
    public static List<?> toList(Object target) {
        Validate.notNull(target, "Cannot convert null to list");
        if (target instanceof List) {
            return (List)target;
        }
        if (target.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])target));
        }
        if (target instanceof Iterable) {
            ArrayList elements = new ArrayList();
            for (Object element : (Iterable)target) {
                elements.add(element);
            }
            return elements;
        }
        throw new IllegalArgumentException("Cannot convert object of class \"" + target.getClass().getName() + "\" to a list");
    }

    public static int size(List<?> target) {
        Validate.notNull(target, "Cannot get list size of null");
        return target.size();
    }

    public static boolean isEmpty(List<?> target) {
        Validate.notNull(target, "Cannot execute list isEmpty: target is null");
        return target.isEmpty();
    }

    public static boolean contains(List<?> target, Object element) {
        Validate.notNull(target, "Cannot execute list contains: target is null");
        return target.contains(element);
    }

    public static boolean containsAll(List<?> target, Object[] elements) {
        Validate.notNull(target, "Cannot execute list containsAll: target is null");
        Validate.notNull(elements, "Cannot execute list containsAll: elements is null");
        return ListUtils.containsAll(target, Arrays.asList(elements));
    }

    public static boolean containsAll(List<?> target, Collection<?> elements) {
        Validate.notNull(target, "Cannot execute list contains: target is null");
        Validate.notNull(elements, "Cannot execute list containsAll: elements is null");
        return target.containsAll(elements);
    }

    private ListUtils() {
    }
}

