/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.thymeleaf.standard.expression.LiteralValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectUtils {
    public static <T> T nullSafe(T target, T defaultValue) {
        return target != null ? target : defaultValue;
    }

    public static boolean evaluateAsBoolean(Object condition) {
        String condStr;
        boolean result = true;
        result = condition == null ? false : (condition instanceof Boolean ? (Boolean)condition : (condition instanceof Number ? (condition instanceof BigDecimal ? !((BigDecimal)condition).equals(BigDecimal.ZERO) : (condition instanceof BigInteger ? !((BigInteger)condition).equals(BigInteger.ZERO) : ((Number)condition).doubleValue() != 0.0)) : (condition instanceof Character ? ((Character)condition).charValue() != '\u0000' : (condition instanceof String ? !(condStr = ((String)condition).trim().toLowerCase()).equals("false") && !condStr.equals("off") && !condStr.equals("no") : (condition instanceof LiteralValue ? !(condStr = ((LiteralValue)condition).getValue().trim().toLowerCase()).equals("false") && !condStr.equals("off") && !condStr.equals("no") : true)))));
        return result;
    }

    public static BigDecimal evaluateAsNumber(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof BigInteger) {
                return new BigDecimal((BigInteger)object);
            }
            if (object instanceof Short) {
                return new BigDecimal(((Short)object).intValue());
            }
            if (object instanceof Integer) {
                return new BigDecimal((Integer)object);
            }
            if (object instanceof Long) {
                return new BigDecimal((Long)object);
            }
            if (object instanceof Float) {
                return new BigDecimal(((Float)object).doubleValue());
            }
            if (object instanceof Double) {
                return new BigDecimal((Double)object);
            }
        } else if (object instanceof String) {
            try {
                return new BigDecimal(((String)object).trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static List<Object> convertToList(Object value) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (value == null) {
            result.add(null);
            return result;
        }
        if (value instanceof Iterable) {
            for (Object obj : (Iterable)value) {
                result.add(obj);
            }
        } else if (value instanceof Map) {
            for (Map.Entry obj : ((Map)value).entrySet()) {
                result.add(obj);
            }
        } else if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                for (byte obj : (byte[])value) {
                    result.add(obj);
                }
            } else if (value instanceof short[]) {
                for (short obj : (short[])value) {
                    result.add(obj);
                }
            } else if (value instanceof int[]) {
                for (int obj : (int[])value) {
                    result.add(obj);
                }
            } else if (value instanceof long[]) {
                for (long obj : (long[])value) {
                    result.add(obj);
                }
            } else if (value instanceof float[]) {
                for (float obj : (float[])value) {
                    result.add(Float.valueOf(obj));
                }
            } else if (value instanceof double[]) {
                for (double obj : (double[])value) {
                    result.add(obj);
                }
            } else if (value instanceof boolean[]) {
                for (boolean obj : (boolean[])value) {
                    result.add(obj);
                }
            } else if (value instanceof char[]) {
                for (char obj : (char[])value) {
                    result.add(Character.valueOf(obj));
                }
            } else {
                for (Object obj : (Object[])value) {
                    result.add(obj);
                }
            }
        } else {
            result.add(value);
        }
        return Collections.unmodifiableList(result);
    }

    public static Object[] convertToArray(Object value) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (value == null) {
            return new Object[]{null};
        }
        if (value instanceof Iterable) {
            for (Object obj : (Iterable)value) {
                result.add(obj);
            }
        } else if (value instanceof Map) {
            for (Map.Entry obj : ((Map)value).entrySet()) {
                result.add(obj);
            }
        } else {
            if (value.getClass().isArray()) {
                return (Object[])value;
            }
            result.add(value);
        }
        return result.toArray(new Object[result.size()]);
    }

    private ObjectUtils() {
    }
}

