/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourcePool<T> {
    private final LinkedList<T> pool;
    private final Set<T> allocated;
    private final Semaphore semaphore;

    public ResourcePool(Collection<T> resources) {
        this.pool = new LinkedList<T>(resources);
        this.allocated = new HashSet<T>(this.pool.size() + 1, 1.0f);
        this.semaphore = new Semaphore(this.pool.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T allocate() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            T object = this.pool.removeFirst();
            this.allocated.add(object);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(T resource) {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            if (this.allocated.contains(resource)) {
                this.pool.addLast(resource);
                this.allocated.remove(resource);
            }
        }
        this.semaphore.release();
    }
}

