/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtils {
    public static String abbreviate(Object target, int maxSize) {
        Validate.notNull(target, "Cannot apply abbreviation on null");
        Validate.isTrue(maxSize >= 3, "Maximum size must be greater or equal to 3");
        String str = target.toString();
        if (str.length() <= maxSize) {
            return str;
        }
        return str.substring(0, maxSize - 3) + "...";
    }

    public static Boolean contains(Object target, String fragment) {
        Validate.notNull(target, "Cannot apply contains on null");
        Validate.notNull(fragment, "Fragment cannot be null");
        return target.toString().contains(fragment);
    }

    public static Boolean containsIgnoreCase(Object target, String fragment, Locale locale) {
        Validate.notNull(target, "Cannot apply containsIgnoreCase on null");
        Validate.notNull(fragment, "Fragment cannot be null");
        Validate.notNull(locale, "Locale cannot be null");
        return target.toString().toUpperCase(locale).contains(fragment.toUpperCase(locale));
    }

    public static Boolean startsWith(Object target, String prefix) {
        Validate.notNull(target, "Cannot apply startsWith on null");
        Validate.notNull(prefix, "Prefix cannot be null");
        return target.toString().startsWith(prefix);
    }

    public static Boolean endsWith(Object target, String suffix) {
        Validate.notNull(target, "Cannot apply endsWith on null");
        Validate.notNull(suffix, "Suffix cannot be null");
        return target.toString().endsWith(suffix);
    }

    public static String substring(Object target, int beginIndex, int endIndex) {
        Validate.notNull(target, "Cannot apply substring on null");
        Validate.isTrue(beginIndex >= 0, "Begin index must be >= 0");
        return new String(target.toString().substring(beginIndex, endIndex));
    }

    public static String substring(Object target, int beginIndex) {
        Validate.notNull(target, "Cannot apply substring on null");
        String str = target.toString();
        int len = str.length();
        Validate.isTrue(beginIndex >= 0 && beginIndex < len, "beginIndex must be >= 0 and < " + len);
        return new String(str.substring(beginIndex));
    }

    public static String substringAfter(Object target, String substr) {
        Validate.notNull(target, "Cannot apply substringAfter on null");
        Validate.notNull(substr, "Parameter substring cannot be null");
        String str = target.toString();
        int index = str.indexOf(substr);
        if (index < 0) {
            return null;
        }
        return new String(str.substring(index + substr.length()));
    }

    public static String substringBefore(Object target, String substr) {
        Validate.notNull(target, "Cannot apply substringBefore on null");
        Validate.notNull(substr, "Parameter substring cannot be null");
        String str = target.toString();
        int index = str.indexOf(substr);
        if (index < 0) {
            return null;
        }
        return new String(str.substring(0, index));
    }

    public static String prepend(Object target, String prefix) {
        Validate.notNull(target, "Cannot apply prepend on null");
        Validate.notNull(prefix, "Prefix cannot be null");
        return prefix + target;
    }

    public static String append(Object target, String suffix) {
        Validate.notNull(target, "Cannot apply append on null");
        Validate.notNull(suffix, "Suffix cannot be null");
        return target + suffix;
    }

    public static Integer indexOf(Object target, String fragment) {
        Validate.notNull(target, "Cannot apply indexOf on null");
        Validate.notNull(fragment, "Fragment cannot be null");
        return target.toString().indexOf(fragment);
    }

    public static Boolean isEmpty(Object target) {
        return target == null || target.toString().trim().equals("");
    }

    public static String join(Object[] target, String separator) {
        Validate.notNull(target, "Cannot apply join on null");
        Validate.notNull(separator, "Separator cannot be null");
        StringBuilder sb = new StringBuilder();
        if (target.length > 0) {
            sb.append(target[0]);
            for (int i = 1; i < target.length; ++i) {
                sb.append(separator);
                sb.append(target[i]);
            }
        }
        return sb.toString();
    }

    public static String join(Iterable<?> target, String separator) {
        Validate.notNull(target, "Cannot apply join on null");
        Validate.notNull(separator, "Separator cannot be null");
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = target.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(separator);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    public static String[] split(Object target, String separator) {
        Validate.notNull(target, "Cannot apply split on null");
        Validate.notNull(separator, "Separator cannot be null");
        StringTokenizer strTok = new StringTokenizer(target.toString(), separator);
        int size = strTok.countTokens();
        String[] array = new String[size];
        for (int i = 0; i < size; ++i) {
            array[i] = strTok.nextToken();
        }
        return array;
    }

    public static Integer length(Object target) {
        Validate.notNull(target, "Cannot apply length on null");
        return target.toString().length();
    }

    public static String replace(Object target, String before, String after) {
        Validate.notNull(target, "Cannot apply replace on null");
        Validate.notNull(before, "Parameter \"before\" cannot be null");
        Validate.notNull(after, "Parameter \"after\" cannot be null");
        return target.toString().replace(before, after);
    }

    public static String toUpperCase(Object target, Locale locale) {
        Validate.notNull(target, "Cannot apply toUpperCase on null");
        Validate.notNull(locale, "Locale cannot be null");
        return target.toString().toUpperCase(locale);
    }

    public static String toLowerCase(Object target, Locale locale) {
        Validate.notNull(target, "Cannot apply toLowerCase on null");
        Validate.notNull(locale, "Locale cannot be null");
        return target.toString().toLowerCase(locale);
    }

    public static String trim(Object target) {
        Validate.notNull(target, "Cannot apply trim on null");
        return target.toString().trim();
    }

    public static String capitalize(Object target) {
        Validate.notNull(target, "Cannot apply capitalize on null");
        StringBuilder result = new StringBuilder(target.toString());
        if (result.length() > 0) {
            result.setCharAt(0, Character.toTitleCase(result.charAt(0)));
        }
        return result.toString();
    }

    public static String unCapitalize(Object target) {
        Validate.notNull(target, "Cannot apply unCapitalize on null");
        StringBuilder result = new StringBuilder(target.toString());
        if (result.length() > 0) {
            result.setCharAt(0, Character.toLowerCase(result.charAt(0)));
        }
        return result.toString();
    }

    private static int findNextWord(char[] buffer, int idx, char[] delimiterChars) {
        int len = buffer.length;
        if (idx < 0 || idx >= len) {
            return -1;
        }
        boolean foundDelimiters = idx == 0;
        for (int i = idx; i < len; ++i) {
            boolean isDelimiter;
            char ch = buffer[i];
            boolean bl = delimiterChars == null ? Character.isWhitespace(ch) : (isDelimiter = Arrays.binarySearch(delimiterChars, ch) >= 0);
            if (isDelimiter) {
                foundDelimiters = true;
                continue;
            }
            if (!foundDelimiters) continue;
            return i;
        }
        return -1;
    }

    public static String capitalizeWords(Object target) {
        return StringUtils.capitalizeWords(target, null);
    }

    public static String capitalizeWords(Object target, Object delimiters) {
        char[] delimiterChars;
        Validate.notNull(target, "Cannot apply capitalizeWords on null");
        char[] buffer = target.toString().toCharArray();
        char[] cArray = delimiterChars = delimiters == null ? null : delimiters.toString().toCharArray();
        if (delimiterChars != null) {
            Arrays.sort(delimiterChars);
        }
        int idx = 0;
        idx = StringUtils.findNextWord(buffer, idx, delimiterChars);
        while (idx != -1) {
            buffer[idx] = Character.toTitleCase(buffer[idx]);
            ++idx;
            idx = StringUtils.findNextWord(buffer, idx, delimiterChars);
        }
        return new String(buffer);
    }

    private StringUtils() {
    }
}

