/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf;

import java.lang.reflect.Modifier;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.exceptions.UnexpectedException;

public class FixSyntheticEnhancer
extends Enhancer {
    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass = this.makeClass(applicationClass);
        if (ctClass.isInterface()) {
            return;
        }
        if (ctClass.getName().endsWith(".package")) {
            return;
        }
        for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
            try {
                String methodName;
                int mod = ctMethod.getModifiers();
                if (mod != 4097 || (methodName = ctMethod.getName()).length() <= 3 || !ctMethod.getName().startsWith("get") && !ctMethod.getName().startsWith("set")) continue;
                String propertyName = ctMethod.getName().substring(3);
                propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                try {
                    CtField ctField = ctClass.getDeclaredField(propertyName);
                    if (!this.isProperty(ctField)) {
                    }
                }
                catch (NotFoundException e) {}
                continue;
                Logger.debug((String)"removing synthetic flag from method %s#%s", (Object[])new Object[]{ctClass.getName(), methodName});
                ctMethod.setModifiers(ctMethod.getModifiers() ^ 0x1000);
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)"Error in FixSyntheticEnhancer", (Object[])new Object[0]);
                throw new UnexpectedException("Error in FixSyntheticEnhancer", (Throwable)e);
            }
        }
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
    }

    boolean isProperty(CtField ctField) {
        if (ctField.getName().equals(ctField.getName().toUpperCase()) || ctField.getName().substring(0, 1).equals(ctField.getName().substring(0, 1).toUpperCase())) {
            return false;
        }
        return Modifier.isPublic(ctField.getModifiers()) && !Modifier.isFinal(ctField.getModifiers()) && !Modifier.isStatic(ctField.getModifiers());
    }
}

