/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.dialect;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import play.modules.thymeleaf.dialect.ProcessorUtil;
import play.mvc.Http;
import play.mvc.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayFormAttrProcessor
extends AbstractAttributeModifierAttrProcessor {
    public static final int ATTR_PRECEDENCE = 1001;
    public static final String ATTR_NAME = "form";

    public PlayFormAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1001;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected final Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        String method;
        if (!ATTR_NAME.equalsIgnoreCase(element.getOriginalName())) {
            return Collections.emptyMap();
        }
        Map attrMap = element.getAttributeMap();
        HashMap<String, String> newAttributeValues = new HashMap<String, String>();
        String attributeValue = element.getAttributeValue(attributeName);
        String action = ProcessorUtil.toActionString(arguments, attributeValue);
        newAttributeValues.put("action", action);
        if (!attrMap.containsKey("enctype")) {
            newAttributeValues.put("enctype", "application/x-www-form-urlencoded");
        }
        if (!attrMap.containsKey("method")) {
            newAttributeValues.put("method", "post");
        }
        String string = method = attrMap.containsKey("method") ? ((Attribute)attrMap.get("method")).getValue() : (String)newAttributeValues.get("method");
        if (!"get".equalsIgnoreCase(method) && !"post".equalsIgnoreCase(method)) {
            String separator = action.indexOf(63) != -1 ? "&" : "?";
            action = action + separator + "x-http-method-override=" + method.toUpperCase();
            newAttributeValues.put("action", action);
            newAttributeValues.put("method", "post");
        }
        String encoding = Http.Response.current().encoding;
        newAttributeValues.put("accept-charset", encoding);
        Element authTokenHidden = new Element("input");
        authTokenHidden.setAttribute("type", "hidden");
        authTokenHidden.setAttribute("name", "authenticityToken");
        authTokenHidden.setAttribute("value", Scope.Session.current().getAuthenticityToken());
        element.insertChild(0, (Node)authTokenHidden);
        element.setRecomputeProcessorsImmediately(true);
        return Collections.unmodifiableMap(newAttributeValues);
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

