/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.templates;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.Validate;
import play.Play;

public class PlayFileResourceResolver
implements IResourceResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NAME = "PLAY_FILE";

    public String getName() {
        return NAME;
    }

    public InputStream getResourceAsStream(TemplateProcessingParameters templateProcessingParameters, String resourceName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("locating thymeleaf resource {} templatename = {}", (Object)resourceName, (Object)templateProcessingParameters.getTemplateName());
        }
        Validate.notNull((Object)resourceName, (String)"Resource name cannot be null");
        File resourceFile = new File(Play.applicationPath, resourceName);
        try {
            return new FileInputStream(resourceFile);
        }
        catch (FileNotFoundException e) {
            this.logger.debug("resource file not found {}", (Object)resourceName);
            return null;
        }
    }
}

