/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf;

import java.io.File;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templatemode.StandardTemplateModeHandlers;
import org.thymeleaf.templateresolver.ITemplateResolver;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.modules.thymeleaf.FixSyntheticEnhancer;
import play.modules.thymeleaf.dialect.PlayDialect;
import play.modules.thymeleaf.templates.PlayTemplateResolver;
import play.modules.thymeleaf.templates.ThymeleafTemplate;
import play.templates.Template;
import play.vfs.VirtualFile;

public class ThymeleafPlugin
extends PlayPlugin {
    private TemplateEngine templateEngine;
    private boolean enhancerEnabled;
    private String prefix;
    private String suffix;
    private String mode;
    private String ttlString;

    public void onLoad() {
        this.enhancerEnabled = BooleanUtils.toBoolean((String)Play.configuration.getProperty("thymeleaf.enhancer.enabled", "true"));
        Logger.debug((String)"thymeleaf plugin enhancer enabled ? :%s", (Object[])new Object[]{this.enhancerEnabled});
    }

    public void onConfigurationRead() {
        this.prefix = Play.configuration.getProperty("thymeleaf.prefix", "/app/thviews");
        this.suffix = Play.configuration.getProperty("thymeleaf.suffix");
        this.mode = Play.configuration.getProperty("thymeleaf.templatemode", StandardTemplateModeHandlers.XHTML.getTemplateModeName());
        this.ttlString = Play.configuration.getProperty("thymeleaf.cache.ttl");
    }

    public void onApplicationStart() {
        PlayTemplateResolver playResolver = new PlayTemplateResolver();
        VirtualFile throot = VirtualFile.open((File)Play.applicationPath).child(this.prefix);
        playResolver.setPrefix(this.prefix);
        Play.templatesPath.add(0, throot);
        if (this.suffix != null) {
            playResolver.setSuffix(this.suffix);
        }
        playResolver.setTemplateMode(this.mode);
        switch (Play.mode) {
            case DEV: {
                playResolver.setCacheable(false);
                break;
            }
            default: {
                if (this.ttlString == null) break;
                if (!NumberUtils.isDigits((String)this.ttlString)) {
                    Logger.warn((String)"Configuration 'thymeleaf.cache.ttl' value %s must be number(in millisecond).", (Object[])new Object[]{this.ttlString});
                    this.ttlString = "0";
                }
                playResolver.setCacheTTLMs(Long.valueOf(this.ttlString));
            }
        }
        this.templateEngine = new TemplateEngine();
        this.templateEngine.addTemplateResolver((ITemplateResolver)playResolver);
        this.templateEngine.addDialect((IDialect)new PlayDialect());
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        if (this.enhancerEnabled) {
            new FixSyntheticEnhancer().enhanceThisClass(applicationClass);
        }
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public Template loadTemplate(VirtualFile file) {
        String relativePath = file.relativePath();
        String templatePath = StringUtils.removeStart((String)relativePath, (String)this.prefix);
        if (relativePath.length() == templatePath.length()) {
            if (Logger.isDebugEnabled()) {
                Logger.debug((String)"%s is not in thymeleaf path", (Object[])new Object[]{templatePath});
            }
            return null;
        }
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)"loading %s from thymeleaf path %s", (Object[])new Object[]{templatePath, this.prefix});
        }
        ThymeleafTemplate template = new ThymeleafTemplate(this.templateEngine, file);
        template.name = templatePath;
        return template;
    }
}

