/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.dialect;

import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import play.data.validation.Error;
import play.data.validation.Validation;

public class PlayErrorAttrProcessor
extends AbstractAttrProcessor {
    public static final int ATTR_PRECEDENCE = 1300;
    public static final String ATTR_NAME = "error";

    public PlayErrorAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1300;
    }

    private String getText(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Error error = Validation.error((String)attributeValue);
        if (error != null) {
            return error.message();
        }
        return null;
    }

    public ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        String msg = this.getText(arguments, element, attributeName);
        if (msg == null) {
            element.getParent().removeChild((Node)element);
        } else {
            element.clearChildren();
            element.addChild((Node)new Text(msg));
            element.removeAttribute(attributeName);
        }
        return ProcessorResult.OK;
    }
}

