/*
 * Decompiled with CFR 0.152.
 */
package play.modules.thymeleaf.dialect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.standard.expression.OgnlExpressionEvaluator;
import play.Logger;
import play.exceptions.ActionNotFoundException;
import play.mvc.ActionInvoker;
import play.mvc.Http;
import play.mvc.Router;
import play.utils.Java;

class ProcessorUtil {
    private static final Pattern PARAM_PATTERN = Pattern.compile("^\\s*.*?\\((.*)\\)\\s*$");

    private ProcessorUtil() {
    }

    static String toActionString(Arguments arguments, String attributeValue) {
        Matcher matcher = PARAM_PATTERN.matcher(attributeValue);
        if (!matcher.matches()) {
            return Router.reverse((String)attributeValue).toString();
        }
        String exp = matcher.group(1);
        if (StringUtils.isBlank((String)exp)) {
            return Router.reverse((String)attributeValue).toString();
        }
        Object obj = OgnlExpressionEvaluator.INSTANCE.evaluate(arguments, exp, arguments.getExpressionEvaluationRoot());
        if (obj instanceof Map) {
            return Router.reverse((String)attributeValue, (Map)((Map)obj)).toString();
        }
        List<Object> list = obj instanceof List ? (List<Object>)obj : Arrays.asList(obj);
        HashMap<Object, Object> paramMap = new HashMap<Object, Object>();
        String extracted = StringUtils.substringBefore((String)attributeValue, (String)"(");
        if (!extracted.contains(".")) {
            extracted = Http.Request.current().controller + "." + extracted;
        }
        Object[] actionMethods = ActionInvoker.getActionMethod((String)extracted);
        Object[] paramNames = null;
        try {
            paramNames = Java.parameterNames((Method)((Method)actionMethods[1]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (paramNames.length < list.size()) {
            Logger.warn((String)"param length unmatched. %s", (Object[])new Object[]{Arrays.toString(paramNames)});
            throw new ActionNotFoundException(attributeValue, null);
        }
        for (int i = 0; i < list.size(); ++i) {
            paramMap.put(paramNames[i], list.get(i));
        }
        return Router.reverse((String)extracted, paramMap).toString();
    }
}

