/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IContextExecutionInfo;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
implements IContext {
    public static final String EXEC_INFO_VARIABLE_NAME = "execInfo";
    private Locale locale;
    private final VariablesMap<String, Object> variables;

    protected AbstractContext() {
        this(Locale.getDefault());
    }

    protected AbstractContext(Locale locale) {
        this(locale, new HashMap());
    }

    protected AbstractContext(Locale locale, Map<String, ?> variables) {
        Validate.notNull(locale, "Locale cannot be null");
        this.locale = locale;
        VariablesMap newVariablesMap = new VariablesMap();
        if (variables != null) {
            newVariablesMap.putAll(variables);
        }
        this.variables = newVariablesMap;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        Validate.notNull(locale, "Locale cannot be null");
        this.locale = locale;
    }

    @Override
    public final VariablesMap<String, Object> getVariables() {
        return this.variables;
    }

    public final void setVariable(String name, Object value) {
        Validate.notNull(name, "Variable name cannot be null");
        this.variables.put(name, value);
    }

    public final void setVariables(Map<String, ?> additionalVariables) {
        Validate.notNull(additionalVariables, "Variables map cannot be null");
        this.variables.putAll(additionalVariables);
    }

    public final void clearVariables() {
        this.variables.clear();
    }

    @Override
    public final void addContextExecutionInfo(String templateName) {
        Validate.notEmpty(templateName, "Template name cannot be null or empty");
        this.setVariable(EXEC_INFO_VARIABLE_NAME, this.buildContextExecutionInfo(templateName));
    }

    protected abstract IContextExecutionInfo buildContextExecutionInfo(String var1);
}

