/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.thymeleaf.context.AbstractContext;
import org.thymeleaf.context.IContextExecutionInfo;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.context.WebContextExecutionInfo;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContext
extends AbstractContext
implements IWebContext {
    public static final String PARAM_VARIABLE_NAME = "param";
    public static final String SESSION_VARIABLE_NAME = "session";
    public static final String APPLICATION_VARIABLE_NAME = "application";
    private final HttpServletRequest httpServletRequest;
    private final HttpSession httpSession;
    private final ServletContext servletContext;
    private final VariablesMap<String, String[]> requestParameters;
    private final VariablesMap<String, Object> requestAttributes;
    private final VariablesMap<String, Object> sessionAttributes;
    private final VariablesMap<String, Object> applicationAttributes;

    public WebContext(HttpServletRequest request, ServletContext servletContext) {
        this(request, servletContext, Locale.getDefault());
    }

    public WebContext(HttpServletRequest request, ServletContext servletContext, Locale locale) {
        this(request, servletContext, locale, new HashMap());
    }

    public WebContext(HttpServletRequest request, ServletContext servletContext, Locale locale, Map<String, ?> variables) {
        super(locale, variables);
        Validate.notNull(locale, "Locale cannot be null");
        Validate.notNull(request, "Request cannot be null");
        HttpSession session = request.getSession(false);
        this.httpServletRequest = request;
        this.httpSession = session;
        this.servletContext = servletContext;
        HashMap totalVariables = new HashMap();
        VariablesMap<String, Object> requestAttributesMap = new VariablesMap<String, Object>();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            requestAttributesMap.put(attributeName, request.getAttribute(attributeName));
        }
        totalVariables.putAll(requestAttributesMap);
        VariablesMap<String, String[]> requestParametersMap = new VariablesMap<String, String[]>();
        Enumeration requestParameterNames = request.getParameterNames();
        while (requestParameterNames.hasMoreElements()) {
            String requestParameterName = (String)requestParameterNames.nextElement();
            String[] requestParameterValues = request.getParameterValues(requestParameterName);
            requestParametersMap.put(requestParameterName, requestParameterValues);
        }
        totalVariables.put(PARAM_VARIABLE_NAME, requestParametersMap);
        VariablesMap<String, Object> sessionAttributesMap = new VariablesMap<String, Object>();
        if (null != session) {
            Enumeration sessionAttributeNames = session.getAttributeNames();
            while (sessionAttributeNames.hasMoreElements()) {
                String sessionAttributeName = (String)sessionAttributeNames.nextElement();
                sessionAttributesMap.put(sessionAttributeName, session.getAttribute(sessionAttributeName));
            }
        }
        totalVariables.put(SESSION_VARIABLE_NAME, sessionAttributesMap);
        VariablesMap<String, Object> applicationAttributesMap = new VariablesMap<String, Object>();
        Enumeration applicationAttributeNames = this.servletContext.getAttributeNames();
        while (applicationAttributeNames.hasMoreElements()) {
            String applicationAttributeName = (String)applicationAttributeNames.nextElement();
            applicationAttributesMap.put(applicationAttributeName, this.servletContext.getAttribute(applicationAttributeName));
        }
        totalVariables.put(APPLICATION_VARIABLE_NAME, applicationAttributesMap);
        this.setVariables(totalVariables);
        this.requestParameters = requestParametersMap;
        this.requestAttributes = requestAttributesMap;
        this.sessionAttributes = sessionAttributesMap;
        this.applicationAttributes = applicationAttributesMap;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public VariablesMap<String, String[]> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public VariablesMap<String, Object> getRequestAttributes() {
        return this.requestAttributes;
    }

    @Override
    public VariablesMap<String, Object> getSessionAttributes() {
        return this.sessionAttributes;
    }

    @Override
    public VariablesMap<String, Object> getApplicationAttributes() {
        return this.applicationAttributes;
    }

    @Override
    protected IContextExecutionInfo buildContextExecutionInfo(String templateName) {
        Calendar now = Calendar.getInstance();
        return new WebContextExecutionInfo(templateName, now);
    }
}

