/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.DocType;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.util.Validate;

public final class Document
extends NestableNode {
    private static final long serialVersionUID = 8647371304942210133L;
    private DocType docType;

    public Document() {
        this((String)null, (DocType)null);
    }

    public Document(DocType docType) {
        this(null, docType);
    }

    public Document(String documentName) {
        this(documentName, (DocType)null);
    }

    public Document(String documentName, DocType docType) {
        super(documentName, null);
        this.docType = docType;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public boolean hasDocType() {
        return this.docType != null;
    }

    final void doAdditionalPrecomputeNestableNode(Configuration configuration) {
        if (this.docType != null) {
            this.docType.process(configuration);
        }
    }

    public final void precompute(Configuration configuration) {
        Validate.notNull(configuration, "Configuration cannot be null");
        this.precomputeNode(configuration);
    }

    public final void process(Arguments arguments) {
        Validate.notNull(arguments, "Arguments cannot be null");
        this.processNode(arguments, arguments.getProcessOnlyElementNodes());
    }

    public Document clone(boolean cloneProcessors) {
        return (Document)this.cloneNode(null, cloneProcessors);
    }

    Node createClonedInstance(NestableNode newParent, boolean cloneProcessors) {
        return new Document(this.docType);
    }

    void doCloneNestableNodeInternals(NestableNode node, NestableNode newParent, boolean cloneProcessors) {
    }
}

