/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssignationSequence
implements Iterable<Assignation>,
Serializable {
    private static final long serialVersionUID = -4915282307441011014L;
    private static final char SEQUENCE_SEPARATOR_CHAR = ',';
    private final List<Assignation> assignations;

    private AssignationSequence(List<Assignation> assignations) {
        Validate.notNull(assignations, "Assignation list cannot be null");
        Validate.containsNoNulls(assignations, "Assignation list cannot contain any nulls");
        this.assignations = Collections.unmodifiableList(assignations);
    }

    public List<Assignation> getAssignations() {
        return this.assignations;
    }

    public int size() {
        return this.assignations.size();
    }

    @Override
    public Iterator<Assignation> iterator() {
        return this.assignations.iterator();
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.assignations.size() > 0) {
            sb.append(this.assignations.get(0));
            for (int i = 1; i < this.assignations.size(); ++i) {
                sb.append(',');
                sb.append(this.assignations.get(i));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    static AssignationSequence parse(String input, boolean allowParametersWithoutValue) {
        if (input == null || input.trim().equals("")) {
            return null;
        }
        List<ExpressionParsingNode> result = SimpleExpression.decomposeSimpleExpressionsExceptNumberLiterals(input);
        if (result == null) {
            return null;
        }
        if ((result = AssignationSequence.composeSequence(result, 0, allowParametersWithoutValue)) == null || !result.get(0).isAssignationSequence()) {
            return null;
        }
        return result.get(0).getAssignationSequence();
    }

    private static List<ExpressionParsingNode> composeSequence(List<ExpressionParsingNode> inputExprs, int inputIndex, boolean allowParametersWithoutValue) {
        if (inputExprs == null || inputExprs.size() == 0 || inputIndex >= inputExprs.size()) {
            return null;
        }
        String input = inputExprs.get(inputIndex).getInput();
        StringBuilder inputWithPlaceholders = new StringBuilder();
        StringBuilder fragment = new StringBuilder();
        ArrayList<ExpressionParsingNode> fragments = new ArrayList<ExpressionParsingNode>();
        int currentIndex = inputExprs.size();
        ArrayList<Integer> assignationIndexes = new ArrayList<Integer>();
        int inputLen = input.length();
        for (int i = 0; i < inputLen; ++i) {
            char c = input.charAt(i);
            if (c == ',') {
                if (fragments.size() > 0) {
                    inputWithPlaceholders.append(',');
                }
                assignationIndexes.add(currentIndex);
                inputWithPlaceholders.append('\u00a7');
                inputWithPlaceholders.append(String.valueOf(currentIndex++));
                inputWithPlaceholders.append('\u00a7');
                fragments.add(new ExpressionParsingNode(fragment.toString()));
                fragment = new StringBuilder();
                continue;
            }
            fragment.append(c);
        }
        if (fragments.size() > 0) {
            inputWithPlaceholders.append(',');
        }
        assignationIndexes.add(currentIndex);
        inputWithPlaceholders.append('\u00a7');
        inputWithPlaceholders.append(String.valueOf(currentIndex++));
        inputWithPlaceholders.append('\u00a7');
        fragments.add(new ExpressionParsingNode(fragment.toString()));
        List<ExpressionParsingNode> result = inputExprs;
        result.set(inputIndex, new ExpressionParsingNode(inputWithPlaceholders.toString()));
        result.addAll(fragments);
        ArrayList<Assignation> assignations = new ArrayList<Assignation>();
        for (Integer assignationIndex : assignationIndexes) {
            int assignationIdx = assignationIndex;
            if ((result = Assignation.composeAssignation(result, assignationIdx, allowParametersWithoutValue)) == null) {
                return null;
            }
            ExpressionParsingNode assignationNode = result.get(assignationIdx);
            if (!assignationNode.isAssignation()) {
                return null;
            }
            assignations.add(assignationNode.getAssignation());
        }
        AssignationSequence assignationSequence = new AssignationSequence(assignations);
        result.set(inputIndex, new ExpressionParsingNode(assignationSequence));
        return result;
    }
}

