/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.MultiplicationDivisionRemainderExpression;
import org.thymeleaf.util.ObjectUtils;

public final class MultiplicationExpression
extends MultiplicationDivisionRemainderExpression {
    private static final long serialVersionUID = 4822815123712162053L;
    private static final Logger logger = LoggerFactory.getLogger(MultiplicationExpression.class);

    public MultiplicationExpression(Expression left, Expression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("*");
    }

    static Object executeMultiplication(Arguments arguments, MultiplicationExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating multiplication expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        Object leftValue = Expression.execute(arguments, expression.getLeft(), expressionEvaluator);
        Object rightValue = Expression.execute(arguments, expression.getRight(), expressionEvaluator);
        if (leftValue == null) {
            leftValue = "null";
        }
        if (rightValue == null) {
            rightValue = "null";
        }
        BigDecimal leftNumberValue = ObjectUtils.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = ObjectUtils.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            return leftNumberValue.multiply(rightNumberValue);
        }
        throw new TemplateProcessingException("Cannot execute multiplication: operands are \"" + LiteralValue.unwrap(leftValue) + "\" and \"" + LiteralValue.unwrap(rightValue) + "\"");
    }
}

