/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpressionEvaluator;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.util.Validate;

public final class VariableExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(VariableExpression.class);
    private static final long serialVersionUID = -4911752782987240708L;
    static final char SELECTOR = '$';
    private static final Pattern VAR_PATTERN = Pattern.compile("^\\s*\\$\\{(.+?)\\}\\s*$", 32);
    static final Expression NULL_VALUE = VariableExpression.parseVariable("${null}");
    private final String expression;

    public VariableExpression(String expression) {
        Validate.notNull(expression, "Expression cannot be null");
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getStringRepresentation() {
        return String.valueOf('$') + String.valueOf('{') + this.expression + String.valueOf('}');
    }

    static VariableExpression parseVariable(String input) {
        Matcher matcher = VAR_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        return new VariableExpression(matcher.group(1));
    }

    static Object executeVariable(Arguments arguments, VariableExpression expression, IStandardExpressionEvaluator expressionEvaluator) {
        String exp;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating variable expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if ((exp = expression.getExpression()) == null) {
            throw new TemplateProcessingException("Variable expression is null, which is not allowed");
        }
        Object evaluationRoot = arguments.getExpressionEvaluationRoot();
        return expressionEvaluator.evaluate(arguments, exp, evaluationRoot);
    }
}

