/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.TemplateInputException;

public final class EntitySubstitutionTemplateReader
extends Reader {
    private static final Logger readerLogger = LoggerFactory.getLogger(EntitySubstitutionTemplateReader.class);
    public static final char CHAR_ENTITY_START_SUBSTITUTE = '\ufff8';
    private static final char CHAR_WHITESPACE_WILDCARD = '\u01f7';
    private static final char CHAR_ALPHANUMERIC_WILDCARD = '\u0234';
    private static final char[] COMMENT_START = "<!--".toCharArray();
    private static final char[] COMMENT_END = "-->".toCharArray();
    private static final char[] ENTITY = "&\u0234;".toCharArray();
    private static final char[] ENTITY_START_SUBSTITUTE = new char[]{'\ufff8'};
    private final BufferedReader bufferedReader;
    private char[] buffer;
    private char[] overflow;
    private int overflowIndex;
    private boolean inComment = false;
    private boolean noMoreToRead = false;

    public EntitySubstitutionTemplateReader(Reader in, int bufferSize) {
        this.bufferedReader = new BufferedReader(in, bufferSize);
        this.buffer = new char[bufferSize + 1024];
        this.overflow = new char[bufferSize + 2048];
        this.overflowIndex = 0;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int copied;
        int toBeOverFlowed;
        int copied2;
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] CALLING read(char[], {}, {})", new Object[]{TemplateEngine.threadIndex(), off, len});
        }
        if (len * 2 > this.overflow.length) {
            this.buffer = new char[len + 1024];
            char[] newOverflow = new char[len + 2048];
            System.arraycopy(this.overflow, 0, newOverflow, 0, this.overflowIndex);
            this.overflow = newOverflow;
        }
        int bufferSize = 0;
        if (this.overflowIndex > 0) {
            int copied3 = this.copyToResult(this.overflow, 0, this.overflowIndex, this.buffer, 0, this.buffer.length);
            bufferSize += copied3;
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] READ FROM OVERFLOW BUFFER {} Some content from the overflow buffer has been copied into results.", new Object[]{TemplateEngine.threadIndex(), copied3});
            }
        }
        char[] overflowOverflow = null;
        if (this.overflowIndex > 0) {
            overflowOverflow = new char[this.overflowIndex];
            System.arraycopy(this.overflow, 0, overflowOverflow, 0, this.overflowIndex);
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] RELLOCATED SOME OVERFLOW CONTENTS, WAITING TO BE ADDED TO RESULT/NEW OVERFLOW {} Some content was remaining at the overflow buffer and will have to be rellocated.", new Object[]{TemplateEngine.threadIndex(), this.overflowIndex});
            }
            this.overflowIndex = 0;
        }
        if (!this.noMoreToRead && bufferSize < this.buffer.length) {
            int toBeRead = this.buffer.length - bufferSize;
            int reallyRead = this.bufferedReader.read(this.buffer, bufferSize, toBeRead);
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] READ FROM SOURCE {} A read operation was executed on the source reader (max chars requested: {}).", new Object[]{TemplateEngine.threadIndex(), reallyRead, toBeRead});
            }
            if (reallyRead < 0) {
                if (bufferSize == 0) {
                    if (readerLogger.isTraceEnabled()) {
                        readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] RETURN {} After trying to read from input: No input left, no buffer left.", new Object[]{TemplateEngine.threadIndex(), reallyRead});
                    }
                    return reallyRead;
                }
                this.noMoreToRead = true;
            } else {
                bufferSize += reallyRead;
            }
        }
        if (this.noMoreToRead && bufferSize == 0) {
            if (readerLogger.isTraceEnabled()) {
                readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] RETURN -1 Reader was already marked to be finished. No more input, no more buffer.", new Object[]{TemplateEngine.threadIndex()});
            }
            return -1;
        }
        int totalRead = 0;
        int cbufi = off;
        int last = off + len;
        int buffi = 0;
        while (cbufi < last && buffi < bufferSize) {
            int copied4;
            int matchedEntity;
            int matchedStartOfComment = this.inComment ? -2 : EntitySubstitutionTemplateReader.match(COMMENT_START, 0, COMMENT_START.length, this.buffer, buffi, bufferSize);
            int matchedEndOfComment = this.inComment ? EntitySubstitutionTemplateReader.match(COMMENT_END, 0, COMMENT_END.length, this.buffer, buffi, bufferSize) : -2;
            int n = matchedEntity = this.inComment ? -2 : EntitySubstitutionTemplateReader.match(ENTITY, 0, ENTITY.length, this.buffer, buffi, bufferSize);
            if (matchedStartOfComment > 0) {
                this.inComment = true;
                copied4 = this.copyToResult(this.buffer, buffi, matchedStartOfComment, cbuf, cbufi, last);
                cbufi += copied4;
                totalRead += copied4;
                buffi += matchedStartOfComment;
                continue;
            }
            if (matchedEndOfComment > 0) {
                this.inComment = false;
                copied4 = this.copyToResult(this.buffer, buffi, matchedEndOfComment, cbuf, cbufi, last);
                cbufi += copied4;
                totalRead += copied4;
                buffi += matchedEndOfComment;
                continue;
            }
            if (matchedEntity > 0) {
                copied4 = this.copyToResult(ENTITY_START_SUBSTITUTE, 0, ENTITY_START_SUBSTITUTE.length, cbuf, cbufi, last);
                cbufi += copied4;
                totalRead += copied4;
                ++buffi;
                continue;
            }
            cbuf[cbufi++] = this.buffer[buffi++];
            ++totalRead;
        }
        if (buffi < bufferSize && (copied2 = this.copyToResult(this.buffer, buffi, toBeOverFlowed = bufferSize - buffi, cbuf, cbufi, last)) != 0) {
            throw new TemplateInputException("Overflow was not correctly computed!");
        }
        if (overflowOverflow != null && (copied = this.copyToResult(overflowOverflow, 0, overflowOverflow.length, cbuf, cbufi, last)) != 0) {
            throw new TemplateInputException("Overflow-overflow was not correctly computed!");
        }
        if (readerLogger.isTraceEnabled()) {
            char[] result = new char[totalRead];
            System.arraycopy(cbuf, off, result, 0, totalRead);
            readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] RETURN {} Input was read and processed. Returning content: [[{}]]", new Object[]{TemplateEngine.threadIndex(), totalRead, new String(result)});
        }
        return totalRead;
    }

    public int read() throws IOException {
        char[] cbuf;
        int res;
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] CALLING read(). Will be delegated to read(char[], 0, 1).", new Object[]{TemplateEngine.threadIndex()});
        }
        if ((res = this.read(cbuf = new char[1], 0, 1)) <= 0) {
            return res;
        }
        return cbuf[0];
    }

    public int read(CharBuffer target) throws IOException {
        int read;
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] CALLING read(CharBuffer). Will be delegated as several calls to read(char[], 0, 1024).", new Object[]{TemplateEngine.threadIndex()});
        }
        char[] cbuf = new char[1024];
        int totalRead = -1;
        while ((read = this.read(cbuf, 0, cbuf.length)) != -1) {
            target.put(cbuf, 0, read);
            if (totalRead == -1) {
                totalRead = 0;
            }
            totalRead += read;
        }
        return totalRead;
    }

    public int read(char[] cbuf) throws IOException {
        if (readerLogger.isTraceEnabled()) {
            readerLogger.trace("[THYMELEAF][HTMLTEMPLATEREADER][{}] CALLING read(char[] cbuf). Will be delegated to read(cbuf, 0, cbuf.length).", new Object[]{TemplateEngine.threadIndex()});
        }
        return this.read(cbuf, 0, cbuf.length);
    }

    public long skip(long n) throws IOException {
        throw new IOException("Skip not supported in reader");
    }

    public boolean ready() throws IOException {
        if (this.bufferedReader.ready()) {
            return true;
        }
        return this.overflowIndex > 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Mark not supported in reader");
    }

    public void reset() throws IOException {
        throw new IOException("Reset not supported in reader");
    }

    public void close() throws IOException {
        this.bufferedReader.close();
    }

    private int copyToResult(char[] fragment, int fragmentOff, int fragmentLen, char[] cbuf, int cbufi, int last) {
        if (cbufi + fragmentLen < last) {
            System.arraycopy(fragment, fragmentOff, cbuf, cbufi, fragmentLen);
            if (fragment == this.overflow) {
                this.overflowIndex = 0;
            }
            return fragmentLen;
        }
        int toBeCopied = last - cbufi;
        int toBeOverflowed = fragmentLen - toBeCopied;
        if (toBeCopied > 0) {
            System.arraycopy(fragment, fragmentOff, cbuf, cbufi, toBeCopied);
        }
        if (fragment != this.overflow) {
            System.arraycopy(fragment, fragmentOff + toBeCopied, this.overflow, this.overflowIndex, toBeOverflowed);
            this.overflowIndex += toBeOverflowed;
        } else {
            System.arraycopy(fragment, fragmentOff + toBeCopied, this.overflow, 0, toBeOverflowed);
            this.overflowIndex = toBeOverflowed;
        }
        return toBeCopied;
    }

    private static int match(char[] fragment, int fragmentOff, int fragmentLen, char[] buffer, int buffi, int bufferLast) {
        char f0 = fragment[fragmentOff];
        if (f0 != '\u01f7' && f0 != '\u0234' && f0 != buffer[buffi]) {
            return -1;
        }
        int fragmentLast = fragmentOff + fragmentLen;
        int buffj = buffi;
        int fragmenti = fragmentOff;
        while (buffj < bufferLast && fragmenti < fragmentLast) {
            char f = fragment[fragmenti];
            if (f == '\u01f7') {
                if (buffer[buffj] != ' ' && buffer[buffj] != '\t') {
                    ++fragmenti;
                    continue;
                }
                ++buffj;
                continue;
            }
            if (f == '\u0234') {
                boolean isHash;
                char c = buffer[buffj];
                boolean isUpper = c >= 'A' && c <= 'Z';
                boolean isLower = c >= 'a' && c <= 'z';
                boolean isDigit = c >= '0' && c <= '9';
                boolean bl = isHash = c == '#';
                if (!isUpper && !isLower && !isDigit && !isHash || fragmenti + 1 < fragmentLast && fragment[fragmenti + 1] == buffer[buffj]) {
                    ++fragmenti;
                    continue;
                }
                ++buffj;
                continue;
            }
            if (buffer[buffj++] == fragment[fragmenti++]) continue;
            return -1;
        }
        if (fragmenti == fragmentLast) {
            return buffj - buffi;
        }
        return -1;
    }

    public static final String removeEntitySubstitutions(String text) {
        if (text == null) {
            return null;
        }
        int textLen = text.length();
        for (int i = 0; i < textLen; ++i) {
            if (text.charAt(i) != '\ufff8') continue;
            char[] textCharArray = text.toCharArray();
            for (int j = 0; j < textLen; ++j) {
                if (textCharArray[j] != '\ufff8') continue;
                textCharArray[j] = 38;
            }
            return new String(textCharArray);
        }
        return text;
    }

    public static final void removeEntitySubstitutions(char[] text, int off, int len) {
        if (text == null) {
            return;
        }
        int finalPos = off + len;
        for (int i = off; i < finalPos; ++i) {
            if (text[i] != '\ufff8') continue;
            text[i] = 38;
        }
    }
}

