/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templatewriter;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.CDATASection;
import org.thymeleaf.dom.Comment;
import org.thymeleaf.dom.DocType;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.templatewriter.ITemplateWriter;
import org.thymeleaf.util.DOMUtils;
import org.thymeleaf.util.Validate;

public abstract class AbstractGeneralTemplateWriter
implements ITemplateWriter {
    private static final char[] COMMENT_PREFIX = "<!--".toCharArray();
    private static final char[] COMMENT_SUFFIX = "-->".toCharArray();
    private static final char[] CDATA_PREFIX = "<![CDATA[".toCharArray();
    private static final char[] CDATA_SUFFIX = "]]>".toCharArray();
    private static final char[] XML_DECLARATION_PREFIX = "<?xml version=\"1.0\"".toCharArray();
    private static final char[] XML_DECLARATION_SUFFIX = "?>\n".toCharArray();

    public void write(Arguments arguments, Writer writer, Document document) throws IOException {
        Validate.notNull(document, "Document cannot be null");
        this.writeDocument(arguments, writer, document);
    }

    protected abstract boolean shouldWriteXmlDeclaration();

    protected abstract boolean useXhtmlTagMinimizationRules();

    protected void writeDocument(Arguments arguments, Writer writer, Document document) throws IOException {
        if (this.shouldWriteXmlDeclaration()) {
            this.writeXmlDeclaration(writer, document);
        }
        if (document.hasDocType()) {
            this.writeDocType(arguments, writer, document.getDocType());
            writer.write(10);
        }
        if (document.hasChildren()) {
            Node[] children = document.unsafeGetChildrenNodeArray();
            int childrenLen = document.numChildren();
            for (int i = 0; i < childrenLen; ++i) {
                this.writeNode(arguments, writer, children[i]);
            }
        }
    }

    protected void writeXmlDeclaration(Writer writer, Document document) throws IOException {
        Boolean xmlStandalone;
        String xmlEncoding;
        writer.write(XML_DECLARATION_PREFIX);
        if (document.hasNodeProperty("XML_ENCODING") && (xmlEncoding = (String)document.getNodeProperty("XML_ENCODING")) != null) {
            writer.write(" encoding=\"");
            writer.write(xmlEncoding);
            writer.write("\"");
        }
        if (document.hasNodeProperty("XML_STANDALONE") && (xmlStandalone = (Boolean)document.getNodeProperty("XML_STANDALONE")) != null && xmlStandalone.booleanValue()) {
            writer.write(" standalone=\"true\"");
        }
        writer.write(XML_DECLARATION_SUFFIX);
    }

    protected void writeDocType(Arguments arguments, Writer writer, DocType docType) throws IOException {
        DocTypeIdentifier writablePublicId = docType.getProcessedPublicId();
        DocTypeIdentifier writableSystemId = docType.getProcessedSystemId();
        if (!docType.isProcessed()) {
            writablePublicId = DocTypeIdentifier.forValue(docType.getPublicId());
            writableSystemId = DocTypeIdentifier.forValue(docType.getSystemId());
        }
        writer.write("<!DOCTYPE ");
        writer.write(docType.getRootElementName());
        if (!writablePublicId.isNone()) {
            writer.write(" PUBLIC \"");
            writablePublicId.write(writer);
            writer.write("\"");
        }
        if (!writableSystemId.isNone()) {
            if (writablePublicId.isNone()) {
                writer.write(" SYSTEM");
            }
            writer.write(" \"");
            writableSystemId.write(writer);
            writer.write("\"");
        }
        writer.write(">");
    }

    public void writeNode(Arguments arguments, Writer writer, Node node) throws IOException {
        Validate.notNull(arguments, "Arguments cannot be null");
        if (node instanceof Element) {
            this.writeElement(arguments, writer, (Element)node);
        } else if (node instanceof Text) {
            this.writeText(arguments, writer, (Text)node);
        } else if (node instanceof Comment) {
            this.writeComment(arguments, writer, (Comment)node);
        } else if (node instanceof CDATASection) {
            this.writeCDATASection(arguments, writer, (CDATASection)node);
        } else if (node instanceof Document) {
            this.writeDocument(arguments, writer, (Document)node);
        } else {
            throw new IllegalStateException("Cannot write node of class \"" + node.getClass().getName());
        }
    }

    protected void writeElement(Arguments arguments, Writer writer, Element element) throws IOException {
        writer.write(60);
        writer.write(element.getOriginalName());
        if (element.hasAttributes()) {
            Configuration configuration = arguments.getConfiguration();
            Attribute[] attributes = element.unsafeGetAttributes();
            int attributesLen = element.numAttributes();
            for (int i = 0; i < attributesLen; ++i) {
                String prefix;
                Attribute attribute = attributes[i];
                boolean writeAttribute = true;
                if (attribute.isXmlnsAttribute()) {
                    String xmlnsPrefix = attribute.getXmlnsPrefix();
                    if (configuration.isPrefixManaged(xmlnsPrefix)) {
                        writeAttribute = configuration.isLenient(xmlnsPrefix);
                    }
                } else if (attribute.hasPrefix() && configuration.isPrefixManaged(prefix = attribute.getNormalizedPrefix()) && !configuration.isLenient(prefix)) {
                    throw new TemplateProcessingException("Error processing template: dialect prefix \"" + attribute.getNormalizedPrefix() + "\" " + "is set as non-lenient but attribute \"" + attribute.getOriginalName() + "\" has not " + "been removed during process", TemplateEngine.threadTemplateName(), element.getLineNumber());
                }
                if (!writeAttribute) continue;
                writer.write(32);
                writer.write(attribute.getOriginalName());
                writer.write(61);
                writer.write(34);
                String attrValue = attribute.getValue();
                if (attrValue != null) {
                    writer.write(DOMUtils.escapeXml(attrValue, true));
                }
                writer.write(34);
            }
        }
        if (element.hasChildren()) {
            writer.write(62);
            Node[] children = element.unsafeGetChildrenNodeArray();
            int childrenLen = element.numChildren();
            for (int i = 0; i < childrenLen; ++i) {
                this.writeNode(arguments, writer, children[i]);
            }
            writer.write(60);
            writer.write(47);
            writer.write(element.getOriginalName());
            writer.write(62);
        } else if (this.useXhtmlTagMinimizationRules()) {
            if (element.isMinimizableIfWeb()) {
                writer.write(32);
                writer.write(47);
                writer.write(62);
            } else {
                writer.write(62);
                writer.write(60);
                writer.write(47);
                writer.write(element.getOriginalName());
                writer.write(62);
            }
        } else {
            writer.write(47);
            writer.write(62);
        }
    }

    protected void writeCDATASection(Arguments arguments, Writer writer, CDATASection cdataSection) throws IOException {
        writer.write(CDATA_PREFIX);
        writer.write(cdataSection.unsafeGetContentCharArray());
        writer.write(CDATA_SUFFIX);
    }

    protected void writeComment(Arguments arguments, Writer writer, Comment comment) throws IOException {
        writer.write(COMMENT_PREFIX);
        writer.write(comment.unsafeGetContentCharArray());
        writer.write(COMMENT_SUFFIX);
    }

    protected void writeText(Arguments arguments, Writer writer, Text text) throws IOException {
        writer.write(text.unsafeGetContentCharArray());
    }
}

