/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Validate {
    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(String object, String message) {
        if (object == null || object.trim().equals("")) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Collection<?> object, String message) {
        if (object == null || object.size() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notEmpty(Object[] object, String message) {
        if (object == null || object.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void containsNoNulls(Iterable<?> collection, String message) {
        for (Object object : collection) {
            Validate.notNull(object, message);
        }
    }

    public static void containsNoEmpties(Iterable<String> collection, String message) {
        for (String object : collection) {
            Validate.notEmpty(object, message);
        }
    }

    public static void containsNoNulls(Object[] array, String message) {
        for (Object object : array) {
            Validate.notNull(object, message);
        }
    }

    public static void isTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private Validate() {
    }
}

