/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.ConfigurationPrinterHelper;
import org.thymeleaf.DialectConfiguration;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.doctype.translation.IDocTypeTranslation;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.AlreadyInitializedException;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.NotInitializedException;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.processor.ProcessorAndContext;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    public static final IDialect STANDARD_THYMELEAF_DIALECT = new StandardDialect();
    private Set<DialectConfiguration> dialectConfigurations = null;
    private Set<ITemplateResolver> templateResolvers = new LinkedHashSet<ITemplateResolver>();
    private Set<IMessageResolver> messageResolvers = new LinkedHashSet<IMessageResolver>();
    private Set<ITemplateModeHandler> templateModeHandlers = new LinkedHashSet<ITemplateModeHandler>();
    private ICacheManager cacheManager = null;
    private Map<String, Set<ProcessorAndContext>> mergedSpecificProcessorsByElementName;
    private Map<String, Set<ProcessorAndContext>> mergedSpecificProcessorsByAttributeName;
    private Map<Class<? extends Node>, Set<ProcessorAndContext>> mergedNonSpecificProcessorsByNodeClass;
    private Map<String, Object> mergedExecutionAttributes = null;
    private Map<String, Boolean> mergedLenienciesByPrefix = null;
    private Set<IDocTypeResolutionEntry> mergedDocTypeResolutionEntries = null;
    private Set<IDocTypeTranslation> mergedDocTypeTranslations = null;
    private Map<String, ITemplateModeHandler> templateModeHandlersByName = new HashMap<String, ITemplateModeHandler>();
    private Set<IMessageResolver> defaultMessageResolvers = null;
    private Set<ITemplateModeHandler> defaultTemplateModeHandlers = null;
    private volatile boolean initialized;

    public Configuration() {
        this.dialectConfigurations = new LinkedHashSet<DialectConfiguration>();
        this.dialectConfigurations.add(new DialectConfiguration(STANDARD_THYMELEAF_DIALECT.getPrefix(), STANDARD_THYMELEAF_DIALECT));
        this.initialized = false;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Cannot modify template engine configuration when it has already been initialized");
        }
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Configuration has not been initialized");
        }
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            if (this.dialectConfigurations == null) {
                throw new ConfigurationException("Cannot initialize: a dialect has not been set");
            }
            for (DialectConfiguration dialectConfiguration : this.dialectConfigurations) {
                dialectConfiguration.initialize();
            }
            MergedDialectArtifacts mergedDialectArtifacts = Configuration.mergeDialects(this.dialectConfigurations);
            this.mergedSpecificProcessorsByElementName = Collections.unmodifiableMap(mergedDialectArtifacts.getSpecificProcessorsByElementName());
            this.mergedSpecificProcessorsByAttributeName = Collections.unmodifiableMap(mergedDialectArtifacts.getSpecificProcessorsByAttributeName());
            this.mergedNonSpecificProcessorsByNodeClass = Collections.unmodifiableMap(mergedDialectArtifacts.getMergedNonSpecificProcessorsByNodeClass());
            this.mergedExecutionAttributes = Collections.unmodifiableMap(mergedDialectArtifacts.getExecutionAttributes());
            this.mergedLenienciesByPrefix = Collections.unmodifiableMap(mergedDialectArtifacts.getLeniencyByPrefix());
            this.mergedDocTypeResolutionEntries = Collections.unmodifiableSet(mergedDialectArtifacts.getDocTypeResolutionEntries());
            this.mergedDocTypeTranslations = Collections.unmodifiableSet(mergedDialectArtifacts.getDocTypeTranslations());
            if (this.templateResolvers == null || this.templateResolvers.size() <= 0) {
                throw new ConfigurationException("Cannot initialize: no template resolvers have been set");
            }
            ArrayList<ITemplateResolver> templateResolversList = new ArrayList<ITemplateResolver>(this.templateResolvers);
            for (ITemplateResolver templateResolver : templateResolversList) {
                templateResolver.initialize();
            }
            Collections.sort(templateResolversList, new Comparator<ITemplateResolver>(){

                @Override
                public int compare(ITemplateResolver o1, ITemplateResolver o2) {
                    if (o1.getOrder() == null) {
                        return -1;
                    }
                    if (o2.getOrder() == null) {
                        return 1;
                    }
                    return o1.getOrder().compareTo(o2.getOrder());
                }
            });
            this.templateResolvers = new LinkedHashSet<ITemplateResolver>(templateResolversList);
            if (this.messageResolvers == null) {
                throw new ConfigurationException("Cannot initialize: message resolvers set is null");
            }
            if (this.messageResolvers.size() == 0) {
                if (this.defaultMessageResolvers == null || this.defaultMessageResolvers.size() == 0) {
                    throw new ConfigurationException("Cannot initialize: no message resolvers have been set and no default message resolvers have been set either.");
                }
                this.messageResolvers = this.defaultMessageResolvers;
            }
            ArrayList<IMessageResolver> messageResolversList = new ArrayList<IMessageResolver>(this.messageResolvers);
            Collections.sort(messageResolversList, new Comparator<IMessageResolver>(){

                @Override
                public int compare(IMessageResolver o1, IMessageResolver o2) {
                    if (o1.getOrder() == null) {
                        return -1;
                    }
                    if (o2.getOrder() == null) {
                        return 1;
                    }
                    return o1.getOrder().compareTo(o2.getOrder());
                }
            });
            this.messageResolvers = new LinkedHashSet<IMessageResolver>(messageResolversList);
            for (IMessageResolver messageResolver : this.messageResolvers) {
                messageResolver.initialize();
            }
            if (this.templateModeHandlers == null) {
                throw new ConfigurationException("Cannot initialize: template mode handlers set is null");
            }
            if (this.templateModeHandlers.size() == 0) {
                if (this.defaultTemplateModeHandlers == null || this.defaultTemplateModeHandlers.size() == 0) {
                    throw new ConfigurationException("Cannot initialize: no template mode handlers have been set and no default template mode handlers have been set either.");
                }
                this.templateModeHandlers = this.defaultTemplateModeHandlers;
            }
            for (ITemplateModeHandler handler : this.templateModeHandlers) {
                if (this.templateModeHandlersByName.containsKey(handler.getTemplateModeName())) {
                    throw new ConfigurationException("More than one handler configured for template mode \"" + handler.getTemplateModeName() + "\"");
                }
                if (handler.getTemplateParser() == null) {
                    throw new ConfigurationException("Null parser returned by handler for template mode \"" + handler.getTemplateModeName() + "\"");
                }
                this.templateModeHandlersByName.put(handler.getTemplateModeName(), handler);
            }
            this.initialized = true;
        }
    }

    void printConfiguration() {
        ConfigurationPrinterHelper.printConfiguration(this.dialectConfigurations, this.mergedLenienciesByPrefix, this.templateResolvers, this.messageResolvers, this.cacheManager, this.templateModeHandlers);
    }

    public ICacheManager getCacheManager() {
        this.checkInitialized();
        return this.cacheManager;
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.checkNotInitialized();
        this.cacheManager = cacheManager;
    }

    public Map<String, IDialect> getDialects() {
        LinkedHashMap<String, IDialect> dialects = new LinkedHashMap<String, IDialect>();
        for (DialectConfiguration dialectConfiguration : this.dialectConfigurations) {
            dialects.put(dialectConfiguration.getPrefix(), dialectConfiguration.getDialect());
        }
        return dialects;
    }

    public void setDialects(Map<String, IDialect> dialects) {
        this.checkNotInitialized();
        Validate.notNull(dialects, "Dialect set cannot be null");
        Validate.isTrue(dialects.size() > 0, "Dialect set cannot be empty");
        this.dialectConfigurations.clear();
        for (Map.Entry<String, IDialect> dialectEntry : dialects.entrySet()) {
            this.dialectConfigurations.add(new DialectConfiguration(dialectEntry.getKey(), dialectEntry.getValue()));
        }
    }

    public void setDialect(IDialect dialect) {
        this.checkNotInitialized();
        Validate.notNull(dialect, "Dialect set cannot be null");
        this.dialectConfigurations.clear();
        this.dialectConfigurations.add(new DialectConfiguration(dialect.getPrefix(), dialect));
    }

    public void addDialect(String prefix, IDialect dialect) {
        this.checkNotInitialized();
        Validate.notNull(dialect, "Dialect set cannot be null");
        this.dialectConfigurations.add(new DialectConfiguration(prefix, dialect));
    }

    public void clearDialects() {
        this.checkNotInitialized();
        this.dialectConfigurations.clear();
    }

    public Set<ITemplateResolver> getTemplateResolvers() {
        return Collections.unmodifiableSet(this.templateResolvers);
    }

    public void setTemplateResolvers(Set<? extends ITemplateResolver> templateResolvers) {
        this.checkNotInitialized();
        Validate.notNull(templateResolvers, "Template Resolver set cannot be null");
        Validate.isTrue(templateResolvers.size() > 0, "Template Resolver set cannot be empty");
        Validate.containsNoNulls(templateResolvers, "Template Resolver set cannot contain any nulls");
        this.templateResolvers = new LinkedHashSet<ITemplateResolver>(templateResolvers);
    }

    public void addTemplateResolver(ITemplateResolver templateResolver) {
        this.checkNotInitialized();
        Validate.notNull(templateResolver, "Template Resolver cannot be null");
        this.templateResolvers.add(templateResolver);
    }

    public void setTemplateResolver(ITemplateResolver templateResolver) {
        this.checkNotInitialized();
        Validate.notNull(templateResolver, "Template Resolver cannot be null");
        this.templateResolvers = Collections.singleton(templateResolver);
    }

    public Set<IMessageResolver> getMessageResolvers() {
        return Collections.unmodifiableSet(this.messageResolvers);
    }

    public void setMessageResolvers(Set<? extends IMessageResolver> messageResolvers) {
        this.checkNotInitialized();
        Validate.notNull(messageResolvers, "Message Resolver set cannot be null");
        Validate.isTrue(messageResolvers.size() > 0, "Message Resolver set cannot be empty");
        Validate.containsNoNulls(messageResolvers, "Message Resolver set cannot contain any nulls");
        this.messageResolvers = new LinkedHashSet<IMessageResolver>(messageResolvers);
    }

    public void addMessageResolver(IMessageResolver messageResolver) {
        this.checkNotInitialized();
        Validate.notNull(messageResolver, "Message Resolver cannot be null");
        this.messageResolvers.add(messageResolver);
    }

    public void setMessageResolver(IMessageResolver messageResolver) {
        this.checkNotInitialized();
        Validate.notNull(messageResolver, "Message Resolver cannot be null");
        this.messageResolvers = Collections.singleton(messageResolver);
    }

    public void setDefaultMessageResolvers(Set<? extends IMessageResolver> defaultMessageResolvers) {
        this.checkNotInitialized();
        Validate.notNull(defaultMessageResolvers, "Default Message Resolver set cannot be null");
        Validate.isTrue(defaultMessageResolvers.size() > 0, "Default Message Resolver set cannot be empty");
        Validate.containsNoNulls(defaultMessageResolvers, "Default Message Resolver set cannot contain any nulls");
        this.defaultMessageResolvers = new LinkedHashSet<IMessageResolver>(defaultMessageResolvers);
    }

    public Set<ITemplateModeHandler> getTemplateModeHandlers() {
        return Collections.unmodifiableSet(this.templateModeHandlers);
    }

    public ITemplateModeHandler getTemplateModeHandler(String templateMode) {
        return this.templateModeHandlersByName.get(templateMode);
    }

    public void setTemplateModeHandlers(Set<? extends ITemplateModeHandler> templateModeHandlers) {
        this.checkNotInitialized();
        Validate.notNull(templateModeHandlers, "Template Mode Handler set cannot be null");
        Validate.isTrue(templateModeHandlers.size() > 0, "Template Mode Handler set cannot be empty");
        Validate.containsNoNulls(templateModeHandlers, "Template Mode Handler set cannot contain any nulls");
        this.templateModeHandlers = new LinkedHashSet<ITemplateModeHandler>(templateModeHandlers);
    }

    public void addTemplateModeHandler(ITemplateModeHandler templateModeHandler) {
        this.checkNotInitialized();
        Validate.notNull(templateModeHandler, "Template Mode Handler cannot be null");
        this.templateModeHandlers.add(templateModeHandler);
    }

    public void setDefaultTemplateModeHandlers(Set<? extends ITemplateModeHandler> defaultTemplateModeHandlers) {
        this.checkNotInitialized();
        Validate.notNull(defaultTemplateModeHandlers, "Default Template Mode Handler set cannot be null");
        Validate.isTrue(defaultTemplateModeHandlers.size() > 0, "Default Template Mode Handler set cannot be empty");
        Validate.containsNoNulls(defaultTemplateModeHandlers, "Default Template Mode Handler set cannot contain any nulls");
        this.defaultTemplateModeHandlers = new LinkedHashSet<ITemplateModeHandler>(defaultTemplateModeHandlers);
    }

    public final Set<IDocTypeTranslation> getDocTypeTranslations() {
        this.checkInitialized();
        return this.mergedDocTypeTranslations;
    }

    public final IDocTypeTranslation getDocTypeTranslationBySource(String publicID, String systemID) {
        this.checkInitialized();
        for (IDocTypeTranslation translation : this.mergedDocTypeTranslations) {
            if (!translation.getSourcePublicID().matches(publicID) || !translation.getSourceSystemID().matches(systemID)) continue;
            return translation;
        }
        return null;
    }

    public final Set<IDocTypeResolutionEntry> getDocTypeResolutionEntries() {
        this.checkInitialized();
        return this.mergedDocTypeResolutionEntries;
    }

    public ArrayList<ProcessorAndContext> computeProcessorsForNode(Node node) {
        if (node instanceof Element) {
            ArrayList<ProcessorAndContext> processors = new ArrayList<ProcessorAndContext>();
            Element element = (Element)node;
            Set<ProcessorAndContext> processorsForElementName = this.mergedSpecificProcessorsByElementName.get(element.getNormalizedName());
            if (processorsForElementName != null) {
                for (ProcessorAndContext processorAndContext : processorsForElementName) {
                    if (!processorAndContext.matches(node)) continue;
                    processors.add(processorAndContext);
                }
            }
            String[] attributeNormalizedNames = element.unsafeGetAttributeNormalizedNames();
            int attributesLen = element.numAttributes();
            for (int i = 0; i < attributesLen; ++i) {
                Set<ProcessorAndContext> processorsForAttributeName = this.mergedSpecificProcessorsByAttributeName.get(attributeNormalizedNames[i]);
                if (processorsForAttributeName == null) continue;
                for (ProcessorAndContext processorAndContext : processorsForAttributeName) {
                    if (!processorAndContext.matches(node)) continue;
                    processors.add(processorAndContext);
                }
            }
            Set<ProcessorAndContext> applicableNonSpecificProcessors = this.getApplicableNonSpecificProcessorsToNodeClass(Element.class);
            if (applicableNonSpecificProcessors != null) {
                for (ProcessorAndContext processorAndContext : applicableNonSpecificProcessors) {
                    if (!processorAndContext.matches(node)) continue;
                    processors.add(processorAndContext);
                }
            }
            if (processors.size() > 1) {
                Collections.sort(processors);
            }
            return processors;
        }
        Set<ProcessorAndContext> applicableNonSpecificProcessors = this.getApplicableNonSpecificProcessorsToNodeClass(node.getClass());
        if (applicableNonSpecificProcessors != null) {
            ArrayList<ProcessorAndContext> processors = new ArrayList<ProcessorAndContext>();
            for (ProcessorAndContext processorAndContext : applicableNonSpecificProcessors) {
                if (!processorAndContext.matches(node)) continue;
                processors.add(processorAndContext);
            }
            Collections.sort(processors);
            return processors;
        }
        return null;
    }

    public Map<String, Object> getExecutionAttributes() {
        this.checkInitialized();
        return this.mergedExecutionAttributes;
    }

    public Set<String> getAllPrefixes() {
        this.checkInitialized();
        return this.mergedLenienciesByPrefix.keySet();
    }

    public boolean isLenient(String normalizedPrefix) {
        this.checkInitialized();
        Boolean leniency = this.mergedLenienciesByPrefix.get(normalizedPrefix);
        if (leniency == null) {
            throw new ConfigurationException("Cannot compute leniency for prefix \"" + normalizedPrefix + "\": No dialect/s " + "have been configured for such prefix.");
        }
        return leniency;
    }

    public boolean isPrefixManaged(String prefix) {
        return this.mergedLenienciesByPrefix.containsKey(prefix);
    }

    private Set<ProcessorAndContext> getApplicableNonSpecificProcessorsToNodeClass(Class<? extends Node> nodeClass) {
        HashSet result = null;
        for (Map.Entry<Class<? extends Node>, Set<ProcessorAndContext>> entry : this.mergedNonSpecificProcessorsByNodeClass.entrySet()) {
            Class<? extends Node> entryNodeClass = entry.getKey();
            if (!entryNodeClass.isAssignableFrom(nodeClass)) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.addAll(entry.getValue());
        }
        return result;
    }

    private static MergedDialectArtifacts mergeDialects(Set<DialectConfiguration> dialectConfigurations) {
        if (dialectConfigurations == null || dialectConfigurations.isEmpty()) {
            throw new ConfigurationException("No dialect has been specified");
        }
        HashMap<String, Set<ProcessorAndContext>> specificProcessorsByElementName = new HashMap<String, Set<ProcessorAndContext>>();
        HashMap<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName = new HashMap<String, Set<ProcessorAndContext>>();
        HashMap<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass = new HashMap<Class<? extends Node>, Set<ProcessorAndContext>>();
        HashMap<String, Object> executionAttributes = new HashMap<String, Object>();
        HashSet<IDocTypeResolutionEntry> docTypeResolutionEntries = new HashSet<IDocTypeResolutionEntry>();
        HashSet<IDocTypeTranslation> docTypeTranslations = new HashSet<IDocTypeTranslation>();
        HashMap<String, Boolean> leniencyByPrefix = new HashMap<String, Boolean>();
        if (dialectConfigurations.size() == 1) {
            DialectConfiguration dialectConfiguration = dialectConfigurations.iterator().next();
            IDialect dialect = dialectConfiguration.getDialect();
            specificProcessorsByElementName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByElementName());
            specificProcessorsByAttributeName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByAttributeName());
            nonSpecificProcessorsByNodeClass.putAll(dialectConfiguration.unsafeGetNonSpecificProcessorsByNodeClass());
            executionAttributes.putAll(dialectConfiguration.getExecutionAttributes());
            leniencyByPrefix.put(dialectConfiguration.getPrefix(), dialectConfiguration.isLenient());
            docTypeResolutionEntries.addAll(dialect.getDocTypeResolutionEntries());
            docTypeTranslations.addAll(dialect.getDocTypeTranslations());
            return new MergedDialectArtifacts(specificProcessorsByElementName, specificProcessorsByAttributeName, nonSpecificProcessorsByNodeClass, executionAttributes, leniencyByPrefix, dialect.getDocTypeResolutionEntries(), dialect.getDocTypeTranslations());
        }
        HashSet mergedDialectClasses = new HashSet();
        for (DialectConfiguration dialectConfiguration : dialectConfigurations) {
            IDialect dialect = dialectConfiguration.getDialect();
            if (mergedDialectClasses.contains(dialect.getClass())) {
                throw new ConfigurationException("Dialect is declared twice: " + dialect.getClass().getName());
            }
            specificProcessorsByElementName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByElementName());
            specificProcessorsByAttributeName.putAll(dialectConfiguration.unsafeGetSpecificProcessorsByAttributeName());
            nonSpecificProcessorsByNodeClass.putAll(dialectConfiguration.unsafeGetNonSpecificProcessorsByNodeClass());
            executionAttributes.putAll(dialectConfiguration.getExecutionAttributes());
            String prefix = dialectConfiguration.getPrefix();
            if (leniencyByPrefix.containsKey(prefix)) {
                leniencyByPrefix.put(prefix, dialectConfiguration.isLenient() || (Boolean)leniencyByPrefix.get(prefix) != false);
            } else {
                leniencyByPrefix.put(prefix, dialectConfiguration.isLenient());
            }
            Set<IDocTypeResolutionEntry> dialectDocTypeResolutionEntries = dialect.getDocTypeResolutionEntries();
            for (IDocTypeResolutionEntry dialectDocTypeResolutionEntry : dialectDocTypeResolutionEntries) {
                boolean addDialectDocTypeResolutionEntry = true;
                DocTypeIdentifier dialectDocTypeResolutionEntryPublicID = dialectDocTypeResolutionEntry.getPublicID();
                DocTypeIdentifier dialectDocTypeResolutionEntrySystemID = dialectDocTypeResolutionEntry.getSystemID();
                for (IDocTypeResolutionEntry docTypeResolutionEntry : docTypeResolutionEntries) {
                    DocTypeIdentifier docTypeResolutionEntryPublicID = docTypeResolutionEntry.getPublicID();
                    DocTypeIdentifier docTypeResolutionEntrySystemID = docTypeResolutionEntry.getSystemID();
                    boolean publicIDMatches = false;
                    boolean systemIDMatches = false;
                    if (dialectDocTypeResolutionEntryPublicID == null) {
                        publicIDMatches = docTypeResolutionEntryPublicID == null;
                    } else {
                        boolean bl = publicIDMatches = docTypeResolutionEntryPublicID != null && docTypeResolutionEntryPublicID.equals(dialectDocTypeResolutionEntryPublicID);
                    }
                    if (dialectDocTypeResolutionEntrySystemID == null) {
                        systemIDMatches = docTypeResolutionEntrySystemID == null;
                    } else {
                        boolean bl = systemIDMatches = docTypeResolutionEntrySystemID != null && docTypeResolutionEntrySystemID.equals(dialectDocTypeResolutionEntrySystemID);
                    }
                    if (!publicIDMatches || !systemIDMatches) continue;
                    if (!dialectDocTypeResolutionEntry.equals(docTypeResolutionEntry)) {
                        throw new ConfigurationException("Cannot initialize: two dialects provide different (non-equal) DOCTYPE resolution entries for PUBLICID \"" + docTypeResolutionEntryPublicID + "\" and SYSTEMID \"" + docTypeResolutionEntrySystemID + "\"");
                    }
                    addDialectDocTypeResolutionEntry = false;
                }
                if (!addDialectDocTypeResolutionEntry) continue;
                docTypeResolutionEntries.add(dialectDocTypeResolutionEntry);
            }
            Set<IDocTypeTranslation> dialectDocTypeTranslations = dialect.getDocTypeTranslations();
            for (IDocTypeTranslation dialectDocTypeTranslation : dialectDocTypeTranslations) {
                boolean addDialectDocTypeTranslation = true;
                DocTypeIdentifier dialectDocTypeTranslationSourcePublicID = dialectDocTypeTranslation.getSourcePublicID();
                DocTypeIdentifier dialectDocTypeTranslationSourceSystemID = dialectDocTypeTranslation.getSourceSystemID();
                DocTypeIdentifier dialectDocTypeTranslationTargetPublicID = dialectDocTypeTranslation.getTargetPublicID();
                DocTypeIdentifier dialectDocTypeTranslationTargetSystemID = dialectDocTypeTranslation.getTargetSystemID();
                for (IDocTypeTranslation docTypeTranslation : docTypeTranslations) {
                    DocTypeIdentifier docTypeTranslationSourcePublicID = docTypeTranslation.getSourcePublicID();
                    DocTypeIdentifier docTypeTranslationSourceSystemID = docTypeTranslation.getSourceSystemID();
                    DocTypeIdentifier docTypeTranslationTargetPublicID = docTypeTranslation.getTargetPublicID();
                    DocTypeIdentifier docTypeTranslationTargetSystemID = docTypeTranslation.getTargetSystemID();
                    boolean sourcePublicIDMatches = false;
                    boolean sourceSystemIDMatches = false;
                    if (dialectDocTypeTranslationSourcePublicID == null) {
                        sourcePublicIDMatches = docTypeTranslationSourcePublicID == null;
                    } else {
                        boolean bl = sourcePublicIDMatches = docTypeTranslationSourcePublicID != null && docTypeTranslationSourcePublicID.equals(dialectDocTypeTranslationSourcePublicID);
                    }
                    if (dialectDocTypeTranslationSourceSystemID == null) {
                        sourceSystemIDMatches = docTypeTranslationSourceSystemID == null;
                    } else {
                        boolean bl = sourceSystemIDMatches = docTypeTranslationSourceSystemID != null && docTypeTranslationSourceSystemID.equals(dialectDocTypeTranslationSourceSystemID);
                    }
                    if (!sourcePublicIDMatches || !sourceSystemIDMatches) continue;
                    boolean targetPublicIDMatches = false;
                    boolean targetSystemIDMatches = false;
                    if (dialectDocTypeTranslationTargetPublicID == null) {
                        targetPublicIDMatches = docTypeTranslationTargetPublicID == null;
                    } else {
                        boolean bl = targetPublicIDMatches = docTypeTranslationTargetPublicID != null && docTypeTranslationTargetPublicID.equals(dialectDocTypeTranslationTargetPublicID);
                    }
                    if (dialectDocTypeTranslationTargetSystemID == null) {
                        targetSystemIDMatches = docTypeTranslationTargetSystemID == null;
                    } else {
                        boolean bl = targetSystemIDMatches = docTypeTranslationTargetSystemID != null && docTypeTranslationTargetSystemID.equals(dialectDocTypeTranslationTargetSystemID);
                    }
                    if (!targetPublicIDMatches || !targetSystemIDMatches) {
                        throw new ConfigurationException("Cannot initialize: two dialects provide different (non-equal) DOCTYPE translations for PUBLICID \"" + docTypeTranslationSourcePublicID + "\" and SYSTEMID \"" + docTypeTranslationSourceSystemID + "\"");
                    }
                    addDialectDocTypeTranslation = false;
                }
                if (!addDialectDocTypeTranslation) continue;
                docTypeTranslations.add(dialectDocTypeTranslation);
            }
            mergedDialectClasses.add(dialect.getClass());
        }
        return new MergedDialectArtifacts(specificProcessorsByElementName, specificProcessorsByAttributeName, nonSpecificProcessorsByNodeClass, executionAttributes, leniencyByPrefix, docTypeResolutionEntries, docTypeTranslations);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MergedDialectArtifacts {
        private final Map<String, Set<ProcessorAndContext>> specificProcessorsByElementName;
        private final Map<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName;
        private final Map<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass;
        private final Map<String, Object> executionAttributes;
        private final Map<String, Boolean> leniencyByPrefix;
        private final Set<IDocTypeResolutionEntry> docTypeResolutionEntries;
        private final Set<IDocTypeTranslation> docTypeTranslations;

        public MergedDialectArtifacts(Map<String, Set<ProcessorAndContext>> specificProcessorsByElementName, Map<String, Set<ProcessorAndContext>> specificProcessorsByAttributeName, Map<Class<? extends Node>, Set<ProcessorAndContext>> nonSpecificProcessorsByNodeClass, Map<String, Object> executionAttributes, Map<String, Boolean> leniencyByPrefix, Set<IDocTypeResolutionEntry> docTypeResolutionEntries, Set<IDocTypeTranslation> docTypeTranslations) {
            this.specificProcessorsByElementName = specificProcessorsByElementName;
            this.specificProcessorsByAttributeName = specificProcessorsByAttributeName;
            this.nonSpecificProcessorsByNodeClass = nonSpecificProcessorsByNodeClass;
            this.executionAttributes = executionAttributes;
            this.leniencyByPrefix = leniencyByPrefix;
            this.docTypeResolutionEntries = docTypeResolutionEntries;
            this.docTypeTranslations = docTypeTranslations;
        }

        public Map<String, Set<ProcessorAndContext>> getSpecificProcessorsByElementName() {
            return this.specificProcessorsByElementName;
        }

        public Map<String, Set<ProcessorAndContext>> getSpecificProcessorsByAttributeName() {
            return this.specificProcessorsByAttributeName;
        }

        public Map<Class<? extends Node>, Set<ProcessorAndContext>> getMergedNonSpecificProcessorsByNodeClass() {
            return this.nonSpecificProcessorsByNodeClass;
        }

        public Map<String, Object> getExecutionAttributes() {
            return this.executionAttributes;
        }

        public Map<String, Boolean> getLeniencyByPrefix() {
            return this.leniencyByPrefix;
        }

        public Set<IDocTypeResolutionEntry> getDocTypeResolutionEntries() {
            return this.docTypeResolutionEntries;
        }

        public Set<IDocTypeTranslation> getDocTypeTranslations() {
            return this.docTypeTranslations;
        }
    }
}

