/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.util.Map;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateProcessingParameters {
    private final Configuration configuration;
    private final String templateName;
    private final IContext context;

    public TemplateProcessingParameters(Configuration configuration, String templateName, IContext context) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(templateName, "Template name cannot be null");
        Validate.notNull(context, "Context cannot be null");
        this.configuration = configuration;
        this.templateName = templateName;
        this.context = context;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public IContext getContext() {
        return this.context;
    }

    public Map<String, Object> getExecutionAttributes() {
        return this.configuration.getExecutionAttributes();
    }

    public Object getExecutionAttribute(String attributeName) {
        return this.configuration.getExecutionAttributes().get(attributeName);
    }
}

