/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.DOMVisitor;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.processor.ProcessorAndContext;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.util.IdentityCounter;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Serializable {
    private static final long serialVersionUID = 3082306990735650683L;
    private static final int DEFAULT_NODE_LOCAL_VARIABLES_MAP_SIZE = 3;
    public static final String NODE_PROPERTY_XML_ENCODING = "XML_ENCODING";
    public static final String NODE_PROPERTY_XML_VERSION = "XML_VERSION";
    public static final String NODE_PROPERTY_XML_STANDALONE = "XML_STANDALONE";
    private final String documentName;
    private final Integer lineNumber;
    private final boolean shouldConsiderAsElementForProcessing;
    NestableNode parent;
    private boolean skippable;
    private boolean precomputed;
    private boolean recomputeProcessorsAfterEachExecution;
    private boolean recomputeProcessorsImmediately;
    private HashMap<String, Object> nodeLocalVariables;
    private ArrayList<ProcessorAndContext> processors;
    private HashMap<String, Object> nodeProperties;

    public static String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    public static String applyDialectPrefix(String name, String dialectPrefix) {
        if (name == null) {
            return null;
        }
        if (dialectPrefix == null || dialectPrefix.trim().equals("")) {
            return name;
        }
        return dialectPrefix + ":" + name;
    }

    Node(String documentName, Integer lineNumber) {
        this.documentName = documentName;
        this.lineNumber = lineNumber;
        this.skippable = false;
        this.precomputed = false;
        this.recomputeProcessorsAfterEachExecution = false;
        this.recomputeProcessorsImmediately = false;
        this.nodeLocalVariables = null;
        this.processors = null;
        this.shouldConsiderAsElementForProcessing = this instanceof Element || this instanceof Document;
        this.nodeProperties = null;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public final void setNodeProperty(String name, Object value) {
        Validate.notNull(name, "Property name cannot be null");
        if (this.nodeProperties == null) {
            this.nodeProperties = new HashMap();
        }
        this.nodeProperties.put(name, value);
    }

    public final boolean hasNodeProperty(String name) {
        Validate.notNull(name, "Property name cannot be null");
        if (this.nodeProperties == null) {
            return false;
        }
        return this.nodeProperties.containsKey(name);
    }

    public final Object getNodeProperty(String name) {
        Validate.notNull(name, "Property name cannot be null");
        if (this.nodeProperties == null) {
            return null;
        }
        return this.nodeProperties.get(name);
    }

    public final Set<String> getNodePropertyNames() {
        if (this.nodeProperties == null) {
            return Collections.emptySet();
        }
        return Collections.synchronizedSet(this.nodeProperties.keySet());
    }

    public final Map<String, Object> unsafeGetNodeProperties() {
        return this.nodeProperties;
    }

    public final boolean hasParent() {
        return this.parent != null;
    }

    public final NestableNode getParent() {
        return this.parent;
    }

    public final void setParent(NestableNode parent) {
        this.parent = parent;
    }

    public final boolean getRecomputeProcessorsAfterEachExecution() {
        return this.recomputeProcessorsAfterEachExecution;
    }

    public final void setRecomputeProcessorsAfterEachExecution(boolean recomputeProcessorsAfterEachExecution) {
        this.recomputeProcessorsAfterEachExecution = recomputeProcessorsAfterEachExecution;
    }

    public final boolean getRecomputeProcessorsImmediately() {
        return this.recomputeProcessorsImmediately;
    }

    public final void setRecomputeProcessorsImmediately(boolean recomputeProcessorsImmediately) {
        this.recomputeProcessorsImmediately = recomputeProcessorsImmediately;
    }

    public final boolean isSkippable() {
        return this.skippable;
    }

    public final void setSkippable(boolean skippable) {
        this.skippable = skippable;
        if (!skippable && this.hasParent() && this.parent.isSkippable()) {
            this.parent.setSkippable(false);
        }
        this.doAdditionalSkippableComputing(skippable);
    }

    abstract void doAdditionalSkippableComputing(boolean var1);

    final boolean isDetached() {
        if (this instanceof Document) {
            return false;
        }
        return !this.hasParent();
    }

    final boolean isPrecomputed() {
        return this.precomputed;
    }

    final void setPrecomputed(boolean precomputed) {
        this.precomputed = precomputed;
    }

    public final boolean hasNodeLocalVariables() {
        return this.nodeLocalVariables != null && this.nodeLocalVariables.size() > 0;
    }

    public final Set<String> getNodeLocalVariableNames() {
        if (this.nodeLocalVariables == null) {
            return Collections.emptySet();
        }
        return this.nodeLocalVariables.keySet();
    }

    public final Map<String, Object> unsafeGetNodeLocalVariables() {
        return this.nodeLocalVariables;
    }

    public final void setNodeLocalVariable(String name, Object value) {
        if (this.nodeLocalVariables == null) {
            this.nodeLocalVariables = new HashMap(3);
        }
        this.nodeLocalVariables.put(name, value);
    }

    public final void setAllNodeLocalVariables(Map<String, Object> variables) {
        if (variables != null) {
            if (this.nodeLocalVariables == null) {
                this.nodeLocalVariables = new HashMap<String, Object>(variables);
            } else {
                this.nodeLocalVariables.putAll(variables);
            }
        }
    }

    final void unsafeSetNodeLocalVariables(HashMap<String, Object> variables) {
        this.nodeLocalVariables = variables != null ? variables : null;
    }

    final void precomputeNode(Configuration configuration) {
        if (!this.isPrecomputed()) {
            this.processors = configuration.computeProcessorsForNode(this);
            if (this.processors == null || this.processors.size() == 0) {
                this.skippable = true;
            } else {
                this.setSkippable(false);
            }
            this.setPrecomputed(true);
        }
        this.doAdditionalPrecomputeNode(configuration);
    }

    abstract void doAdditionalPrecomputeNode(Configuration var1);

    void processNode(Arguments arguments, boolean processOnlyElementNodes) {
        if (!this.shouldConsiderAsElementForProcessing && processOnlyElementNodes) {
            return;
        }
        if (this.recomputeProcessorsImmediately || this.recomputeProcessorsAfterEachExecution) {
            this.precomputeNode(arguments.getConfiguration());
            this.recomputeProcessorsImmediately = false;
        }
        if (!this.isPrecomputed()) {
            this.precomputeNode(arguments.getConfiguration());
        }
        if (!this.isSkippable()) {
            Arguments executionArguments;
            Arguments arguments2 = executionArguments = this.nodeLocalVariables != null && this.nodeLocalVariables.size() > 0 ? arguments.addLocalVariables(this.nodeLocalVariables) : arguments;
            if (executionArguments.hasLocalVariables()) {
                this.unsafeSetNodeLocalVariables(executionArguments.unsafeGetLocalVariables());
            }
            if (!this.isDetached() && this.processors != null && this.processors.size() > 0) {
                IdentityCounter<ProcessorAndContext> alreadyExecuted = new IdentityCounter<ProcessorAndContext>(this.processors.size());
                Arguments processingArguments = executionArguments;
                while (!this.isDetached() && processingArguments != null) {
                    if ((processingArguments = Node.applyNextProcessor(processingArguments, this, alreadyExecuted)) != null) {
                        executionArguments = processingArguments;
                    }
                    if (!this.recomputeProcessorsImmediately && !this.recomputeProcessorsAfterEachExecution) continue;
                    this.precomputeNode(arguments.getConfiguration());
                    this.recomputeProcessorsImmediately = false;
                }
            }
            this.doAdditionalProcess(executionArguments, executionArguments.getProcessOnlyElementNodes());
        }
    }

    private static final Arguments applyNextProcessor(Arguments arguments, Node node, IdentityCounter<ProcessorAndContext> alreadyExecuted) {
        if (!node.isDetached() && node.processors != null && node.processors.size() > 0) {
            for (ProcessorAndContext processor : node.processors) {
                if (alreadyExecuted.isAlreadyCounted(processor)) continue;
                Arguments executionArguments = arguments;
                ProcessorResult processorResult = processor.getProcessor().process(executionArguments, processor.getContext(), node);
                executionArguments = processorResult.computeNewArguments(executionArguments);
                if (processorResult.hasLocalVariables() && executionArguments.hasLocalVariables()) {
                    node.unsafeSetNodeLocalVariables(executionArguments.unsafeGetLocalVariables());
                }
                alreadyExecuted.count(processor);
                return executionArguments;
            }
        }
        return null;
    }

    abstract void doAdditionalProcess(Arguments var1, boolean var2);

    public final Node cloneNode(NestableNode newParent, boolean cloneProcessors) {
        Node clone = this.createClonedInstance(newParent, cloneProcessors);
        this.cloneNodeInternals(clone, newParent, cloneProcessors);
        return clone;
    }

    abstract Node createClonedInstance(NestableNode var1, boolean var2);

    final void cloneNodeInternals(Node node, NestableNode newParent, boolean cloneProcessors) {
        this.doCloneNodeInternals(node, newParent, cloneProcessors);
        if (cloneProcessors) {
            node.processors = this.processors;
            node.skippable = this.skippable;
            node.precomputed = this.precomputed;
        } else {
            node.processors = null;
            node.skippable = false;
            node.precomputed = false;
        }
        node.parent = newParent;
        if (this.nodeLocalVariables != null) {
            node.nodeLocalVariables = new HashMap<String, Object>(this.nodeLocalVariables);
        }
        if (this.nodeProperties != null) {
            node.nodeProperties = new HashMap<String, Object>(this.nodeProperties);
        }
    }

    abstract void doCloneNodeInternals(Node var1, NestableNode var2, boolean var3);

    public abstract void visit(DOMVisitor var1);
}

