/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Strings {
    public String abbreviate(Object target, int maxSize) {
        return StringUtils.abbreviate(target, maxSize);
    }

    public String[] arrayAbbreviate(Object[] target, int maxSize) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.abbreviate(target[i], maxSize);
        }
        return result;
    }

    public List<String> listAbbreviate(List<?> target, int maxSize) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.abbreviate(element, maxSize));
        }
        return result;
    }

    public Set<String> setAbbreviate(Set<?> target, int maxSize) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.abbreviate(element, maxSize));
        }
        return result;
    }

    public Boolean contains(Object target, String fragment) {
        return StringUtils.contains(target, fragment);
    }

    public Boolean[] arrayContains(Object[] target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result = new Boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.contains(target[i], fragment);
        }
        return result;
    }

    public List<Boolean> listContains(List<?> target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object element : target) {
            result.add(this.contains(element, fragment));
        }
        return result;
    }

    public Set<Boolean> setContains(Set<?> target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>();
        for (Object element : target) {
            result.add(this.contains(element, fragment));
        }
        return result;
    }

    public Boolean containsIgnoreCase(Object target, String fragment) {
        return StringUtils.containsIgnoreCase(target, fragment, Strings.getLocale());
    }

    public Boolean[] arrayContainsIgnoreCase(Object[] target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result = new Boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.containsIgnoreCase(target[i], fragment);
        }
        return result;
    }

    public List<Boolean> listContainsIgnoreCase(List<?> target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object element : target) {
            result.add(this.containsIgnoreCase(element, fragment));
        }
        return result;
    }

    public Set<Boolean> setContainsIgnoreCase(Set<?> target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>();
        for (Object element : target) {
            result.add(this.containsIgnoreCase(element, fragment));
        }
        return result;
    }

    public Boolean startsWith(Object target, String prefix) {
        return StringUtils.startsWith(target, prefix);
    }

    public Boolean[] arrayStartsWith(Object[] target, String prefix) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result = new Boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.startsWith(target[i], prefix);
        }
        return result;
    }

    public List<Boolean> listStartsWith(List<?> target, String prefix) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object element : target) {
            result.add(this.startsWith(element, prefix));
        }
        return result;
    }

    public Set<Boolean> setStartsWith(Set<?> target, String prefix) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>();
        for (Object element : target) {
            result.add(this.startsWith(element, prefix));
        }
        return result;
    }

    public Boolean endsWith(Object target, String suffix) {
        return StringUtils.endsWith(target, suffix);
    }

    public Boolean[] arrayEndsWith(Object[] target, String suffix) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result = new Boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.endsWith(target[i], suffix);
        }
        return result;
    }

    public List<Boolean> listEndsWith(List<?> target, String suffix) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object element : target) {
            result.add(this.endsWith(element, suffix));
        }
        return result;
    }

    public Set<Boolean> setEndsWith(Set<?> target, String suffix) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>();
        for (Object element : target) {
            result.add(this.endsWith(element, suffix));
        }
        return result;
    }

    public String substring(Object target, int start, int end) {
        return StringUtils.substring(target, start, end);
    }

    public String[] arraySubstring(Object[] target, int start, int end) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.substring(target[i], start, end);
        }
        return result;
    }

    public List<String> listSubstring(List<?> target, int start, int end) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.substring(element, start, end));
        }
        return result;
    }

    public Set<String> setSubstring(Set<?> target, int start, int end) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.substring(element, start, end));
        }
        return result;
    }

    public String substring(Object target, int start) {
        return StringUtils.substring(target, start);
    }

    public String[] arraySubstring(Object[] target, int start) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.substring(target[i], start);
        }
        return result;
    }

    public List<String> listSubstring(List<?> target, int start) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.substring(element, start));
        }
        return result;
    }

    public Set<String> setSubstring(Set<?> target, int start) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.substring(element, start));
        }
        return result;
    }

    public String substringAfter(Object target, String substr) {
        return StringUtils.substringAfter(target, substr);
    }

    public String[] arraySubstringAfter(Object[] target, String substr) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.substringAfter(target[i], substr);
        }
        return result;
    }

    public List<String> listSubstringAfter(List<?> target, String substr) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.substringAfter(element, substr));
        }
        return result;
    }

    public Set<String> setSubstringAfter(Set<?> target, String substr) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.substringAfter(element, substr));
        }
        return result;
    }

    public String substringBefore(Object target, String substr) {
        return StringUtils.substringBefore(target, substr);
    }

    public String[] arraySubstringBefore(Object[] target, String substr) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.substringBefore(target[i], substr);
        }
        return result;
    }

    public List<String> listSubstringBefore(List<?> target, String substr) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.substringBefore(element, substr));
        }
        return result;
    }

    public Set<String> setSubstringBefore(Set<?> target, String substr) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.substringBefore(element, substr));
        }
        return result;
    }

    public String prepend(Object target, String prefix) {
        return StringUtils.prepend(target, prefix);
    }

    public String[] arrayPrepend(Object[] target, String prefix) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.prepend(target[i], prefix);
        }
        return result;
    }

    public List<String> listPrepend(List<?> target, String prefix) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.prepend(element, prefix));
        }
        return result;
    }

    public Set<String> setPrepend(Set<?> target, String prefix) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.prepend(element, prefix));
        }
        return result;
    }

    public String append(Object target, String suffix) {
        return StringUtils.append(target, suffix);
    }

    public String[] arrayAppend(Object[] target, String suffix) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.append(target[i], suffix);
        }
        return result;
    }

    public List<String> listAppend(List<?> target, String suffix) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.append(element, suffix));
        }
        return result;
    }

    public Set<String> setAppend(Set<?> target, String suffix) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.append(element, suffix));
        }
        return result;
    }

    public Integer indexOf(Object target, String fragment) {
        return StringUtils.indexOf(target, fragment);
    }

    public Integer[] arrayIndexOf(Object[] target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.indexOf(target[i], fragment);
        }
        return result;
    }

    public List<Integer> listIndexOf(List<?> target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object element : target) {
            result.add(this.indexOf(element, fragment));
        }
        return result;
    }

    public Set<Integer> setIndexOf(Set<?> target, String fragment) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Object element : target) {
            result.add(this.indexOf(element, fragment));
        }
        return result;
    }

    public Boolean isEmpty(Object target) {
        return StringUtils.isEmpty(target);
    }

    public Boolean[] arrayIsEmpty(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Boolean[] result = new Boolean[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.isEmpty(target[i]);
        }
        return result;
    }

    public List<Boolean> listIsEmpty(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object element : target) {
            result.add(this.isEmpty(element));
        }
        return result;
    }

    public Set<Boolean> setIsEmpty(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Boolean> result = new LinkedHashSet<Boolean>();
        for (Object element : target) {
            result.add(this.isEmpty(element));
        }
        return result;
    }

    public String arrayJoin(Object[] stringArray, String separator) {
        return StringUtils.join(stringArray, separator);
    }

    public String listJoin(List<?> stringIter, String separator) {
        return StringUtils.join(stringIter, separator);
    }

    public String setJoin(Set<?> stringIter, String separator) {
        return StringUtils.join(stringIter, separator);
    }

    public String[] arraySplit(Object target, String separator) {
        return StringUtils.split(target, separator);
    }

    public List<String> listSplit(Object target, String separator) {
        return new ArrayList<String>(Arrays.asList(StringUtils.split(target, separator)));
    }

    public Set<String> setSplit(Object target, String separator) {
        return new LinkedHashSet<String>(Arrays.asList(StringUtils.split(target, separator)));
    }

    public Integer length(Object target) {
        return StringUtils.length(target);
    }

    public Integer[] arrayLength(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        Integer[] result = new Integer[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.length(target[i]);
        }
        return result;
    }

    public List<Integer> listLength(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object element : target) {
            result.add(this.length(element));
        }
        return result;
    }

    public Set<Integer> setLength(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        for (Object element : target) {
            result.add(this.length(element));
        }
        return result;
    }

    public String replace(Object target, String before, String after) {
        return StringUtils.replace(target, before, after);
    }

    public String[] arrayReplace(Object[] target, String before, String after) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.replace(target[i], before, after);
        }
        return result;
    }

    public List<String> listReplace(List<?> target, String before, String after) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.replace(element, before, after));
        }
        return result;
    }

    public Set<String> setReplace(Set<?> target, String before, String after) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.replace(element, before, after));
        }
        return result;
    }

    public String toUpperCase(Object target) {
        return StringUtils.toUpperCase(target, Strings.getLocale());
    }

    public String[] arrayToUpperCase(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.toUpperCase(target[i]);
        }
        return result;
    }

    public List<String> listToUpperCase(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.toUpperCase(element));
        }
        return result;
    }

    public Set<String> setToUpperCase(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.toUpperCase(element));
        }
        return result;
    }

    public String toLowerCase(Object target) {
        return StringUtils.toLowerCase(target, Strings.getLocale());
    }

    public String[] arrayToLowerCase(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.toLowerCase(target[i]);
        }
        return result;
    }

    public List<String> listToLowerCase(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.toLowerCase(element));
        }
        return result;
    }

    public Set<String> setToLowerCase(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.toLowerCase(element));
        }
        return result;
    }

    public String trim(Object target) {
        return StringUtils.trim(target);
    }

    public String[] arrayTrim(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.trim(target[i]);
        }
        return result;
    }

    public List<String> listTrim(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.trim(element));
        }
        return result;
    }

    public Set<String> setTrim(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.trim(element));
        }
        return result;
    }

    public String capitalize(Object target) {
        return StringUtils.capitalize(target);
    }

    public String[] arrayCapitalize(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.capitalize(target[i]);
        }
        return result;
    }

    public List<String> listCapitalize(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.capitalize(element));
        }
        return result;
    }

    public Set<String> setCapitalize(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.capitalize(element));
        }
        return result;
    }

    public String unCapitalize(Object target) {
        return StringUtils.unCapitalize(target);
    }

    public String[] arrayUnCapitalize(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.unCapitalize(target[i]);
        }
        return result;
    }

    public List<String> listUnCapitalize(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.unCapitalize(element));
        }
        return result;
    }

    public Set<String> setUnCapitalize(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.unCapitalize(element));
        }
        return result;
    }

    public String capitalizeWords(Object target) {
        return StringUtils.capitalizeWords(target);
    }

    public String[] arrayCapitalizeWords(Object[] target) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.capitalizeWords(target[i]);
        }
        return result;
    }

    public List<String> listCapitalizeWords(List<?> target) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.capitalizeWords(element));
        }
        return result;
    }

    public Set<String> setCapitalizeWords(Set<?> target) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.capitalizeWords(element));
        }
        return result;
    }

    public String capitalizeWords(Object target, Object delimiters) {
        return StringUtils.capitalizeWords(target, delimiters);
    }

    public String[] arrayCapitalizeWords(Object[] target, Object delimiters) {
        Validate.notNull(target, "Target cannot be null");
        String[] result = new String[target.length];
        for (int i = 0; i < target.length; ++i) {
            result[i] = this.capitalizeWords(target[i], delimiters);
        }
        return result;
    }

    public List<String> listCapitalizeWords(List<?> target, Object delimiters) {
        Validate.notNull(target, "Target cannot be null");
        ArrayList<String> result = new ArrayList<String>();
        for (Object element : target) {
            result.add(this.capitalizeWords(element, delimiters));
        }
        return result;
    }

    public Set<String> setCapitalizeWords(Set<?> target, Object delimiters) {
        Validate.notNull(target, "Target cannot be null");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Object element : target) {
            result.add(this.capitalizeWords(element, delimiters));
        }
        return result;
    }

    private static Locale getLocale() {
        Locale locale = TemplateEngine.threadLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

